/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.struct;

import com.tvd12.properties.file.annotation.PropertyAnnotations;
import com.tvd12.properties.file.util.PropertiesUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class MethodStruct {
    protected Class<?> type;
    protected Method method;
    protected Field field;
    protected String key;
    protected final PropertyAnnotations propertyAnnotations;

    public MethodStruct(PropertyAnnotations propertyAnnotations) {
        this.propertyAnnotations = propertyAnnotations;
    }

    public void initWithMethod(Method meth) {
        this.method = meth;
        this.key = this.getKey(this.method);
        this.type = this.getTypeFromMethod(this.method);
    }

    public void initWithField(Class<?> clazz, Field field) {
        this.field = field;
        this.type = field.getType();
        this.key = this.getKey(field);
        this.method = this.getMethodByField(clazz, field);
    }

    private Method getMethodByField(Class<?> clazz, Field field) {
        try {
            String name = field.getName();
            name = name.startsWith("is") ? name.substring(2) : name;
            return this.getMethod(new PropertyDescriptor(name, clazz));
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    protected abstract Method getMethod(PropertyDescriptor var1);

    protected abstract Class<?> getTypeFromMethod(Method var1);

    protected String getMethodName() {
        return this.method.getName();
    }

    private String getKey(Method method) {
        String mname = this.propertyAnnotations.getPropertyName(method);
        if (!mname.isEmpty()) {
            return mname;
        }
        mname = method.getName();
        if (mname.startsWith("set")) {
            mname = mname.substring(3);
        }
        if (mname.length() < 2) {
            return mname;
        }
        return mname.substring(0, 1).toLowerCase() + mname.substring(1);
    }

    private String getKey(Field field) {
        String mname = this.propertyAnnotations.getPropertyName(field);
        if (!mname.isEmpty()) {
            return mname;
        }
        return field.getName();
    }

    private String getPropertyName() {
        String propertyName = "";
        if (this.field != null) {
            propertyName = this.propertyAnnotations.getPropertyName(this.field);
        }
        if (propertyName.isEmpty() && this.method != null) {
            propertyName = this.propertyAnnotations.getPropertyName(this.method);
        }
        return propertyName;
    }

    public String getPropertyPrefix(boolean guess) {
        String prefix = "";
        String propertyName = this.getPropertyName();
        if (propertyName.isEmpty()) {
            if (this.field != null) {
                prefix = this.propertyAnnotations.getPropertyPrefix(this.field);
            }
            if (prefix.isEmpty() && this.method != null) {
                prefix = this.propertyAnnotations.getPropertyPrefix(this.method);
            }
            if (prefix.isEmpty() && guess) {
                prefix = this.guestPropertyPrefix();
            }
        }
        return prefix;
    }

    public String guestPropertyPrefix() {
        String key = this.getKey();
        return PropertiesUtil.getPropertyNameInDotCase(key);
    }

    public Type getGenericType() {
        if (this.field != null) {
            return this.field.getGenericType();
        }
        return this.method.getGenericParameterTypes()[0];
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public String getKey() {
        return this.key;
    }
}

