/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public final class EzyArrays {
    private EzyArrays() {
    }

    public static void copy(byte[] from, byte[] to, int toPos) {
        int index;
        for (int i = 0; i < from.length && (index = toPos + i) < to.length; ++i) {
            to[index] = from[i];
        }
    }

    public static <I, O> O[] newArray(Collection<I> coll, IntFunction<O[]> generator, Function<I, O> applier) {
        int count = 0;
        O[] answer = generator.apply(coll.size());
        for (I input : coll) {
            answer[count++] = applier.apply(input);
        }
        return answer;
    }

    public static <T extends Comparable> T min(T[] array) {
        return (T)((Comparable)EzyArrays.min(array, Comparable::compareTo));
    }

    public static <T> T min(T[] array, Comparator<T> comparator) {
        return EzyArrays.min(Arrays.stream(array), comparator);
    }

    public static <T> T min(Stream<T> stream, Comparator<T> comparator) {
        return stream.min(comparator).orElseThrow(() -> new IllegalArgumentException("stream is empty"));
    }

    public static <T extends Comparable> T max(T[] array) {
        return (T)((Comparable)EzyArrays.max(array, Comparable::compareTo));
    }

    public static <T> T max(T[] array, Comparator<T> comparator) {
        return EzyArrays.max(Arrays.stream(array), comparator);
    }

    public static <T> T max(Stream<T> stream, Comparator<T> comparator) {
        return stream.max(comparator).orElseThrow(() -> new IllegalArgumentException("stream is empty"));
    }
}

