/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.function.EzyValidator;
import com.tvd12.ezyfox.reflect.EzyTypes;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Set;

public class EzyGenericSetterValidator
implements EzyValidator<Type> {
    @Override
    public boolean validate(Type genericType) {
        if (genericType instanceof WildcardType) {
            return false;
        }
        if (genericType instanceof Class) {
            return this.validateClassType(genericType);
        }
        if (genericType instanceof ParameterizedType) {
            return this.validate((ParameterizedType)genericType);
        }
        return false;
    }

    @Override
    protected boolean validate(ParameterizedType parameterizedType) {
        Type[] types;
        for (Type type : types = parameterizedType.getActualTypeArguments()) {
            if (this.validate(type)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateClassType(Type classType) {
        return !this.getCommonGenericTypes().contains(classType);
    }

    protected Set<Class> getCommonGenericTypes() {
        return EzyTypes.COMMON_GENERIC_TYPES;
    }
}

