/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.function.EzySupplier;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EzyReturner {
    private EzyReturner() {
    }

    public static <T> T returnNotNull(T rvalue, T svalue) {
        return rvalue != null ? rvalue : svalue;
    }

    public static <T> T returnWithException(EzySupplier<T> supplier) {
        return EzyReturner.returnWithException(supplier, IllegalStateException::new);
    }

    public static <T> T returnWithException(EzySupplier<T> supplier, Function<Throwable, RuntimeException> handler) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw handler.apply(e);
        }
    }

    public static <T> T returnWithIllegalArgumentException(EzySupplier<T> supplier) {
        return EzyReturner.returnWithException(supplier, IllegalArgumentException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T returnWithSync(Supplier<T> supplier, Object context) {
        Object object = context;
        synchronized (object) {
            return supplier.get();
        }
    }

    public static <T> T returnWithLock(Supplier<T> supplier, Lock lock) {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

