/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.converter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.AvatarCoverImageIdsModel;
import org.youngmonkeys.ezyplatform.model.ContentTemplateModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;
import org.youngmonkeys.ezyplatform.model.UuidNameModel;
import org.youngmonkeys.ezyplatform.result.AvatarCoverImageIdsResult;
import org.youngmonkeys.ezyplatform.result.IdNameResult;
import org.youngmonkeys.ezyplatform.result.IdUuidNameResult;
import org.youngmonkeys.ezyplatform.result.SimpleContentTemplateResult;
import org.youngmonkeys.ezyplatform.util.LocalDateTimes;

public class DefaultResultToModelConverter {
    protected final ZoneId zoneId;

    public UuidNameModel toModel(IdUuidNameResult result) {
        if (result == null) {
            return null;
        }
        return UuidNameModel.builder().uuid(result.getUuid()).displayName(result.getDisplayName()).build();
    }

    public AvatarCoverImageIdsModel toModel(AvatarCoverImageIdsResult result) {
        if (result == null) {
            return null;
        }
        return AvatarCoverImageIdsModel.builder().avatarImageId(result.getAvatarImageId()).coverImageId(result.getCoverImageId()).build();
    }

    public ContentTemplateModel toModel(SimpleContentTemplateResult result) {
        if (result == null) {
            return null;
        }
        return ContentTemplateModel.builder().id(result.getId()).name(result.getTemplateName()).titleTemplate(result.getTitleTemplate()).creatorId(result.getCreatorId()).status(result.getStatus()).createdAt(this.toTimestamp(result.getCreatedAt())).updatedAt(this.toTimestamp(result.getUpdatedAt())).build();
    }

    public AdminNameModel toAdminNameModel(IdNameResult result) {
        if (result == null) {
            return null;
        }
        return AdminNameModel.builder().adminId(result.getId()).username(result.getUsername()).displayName(result.getDisplayName()).build();
    }

    public UserNameModel toUserNameModel(IdNameResult result) {
        if (result == null) {
            return null;
        }
        return UserNameModel.builder().userId(result.getId()).username(result.getUsername()).displayName(result.getDisplayName()).build();
    }

    protected long toTimestamp(LocalDateTime localDateTime) {
        return LocalDateTimes.toTimestamp(localDateTime, this.zoneId);
    }

    @Generated
    public DefaultResultToModelConverter(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

