/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.data;

import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class UserRolesProxy {
    private FeatureURIManager featureUriManager;
    private Map<String, Set<HttpMethod>> accessibleMethodsByUri;

    public boolean isAccessible(String uri) {
        return this.isAccessible(uri, HttpMethod.GET);
    }

    public boolean isAccessible(String uri, String method) {
        return this.isAccessible(uri, HttpMethod.valueOf((String)method));
    }

    public boolean isAccessible(String uri, HttpMethod method) {
        String feature = this.featureUriManager.getFeatureByURI(method, uri);
        if (feature == null) {
            return true;
        }
        Set methods = this.accessibleMethodsByUri.getOrDefault(uri, Collections.emptySet());
        return methods.contains(method);
    }

    public boolean isAccessibleAny(List<String> urls) {
        for (String url : urls) {
            if (!this.isAccessible(url)) continue;
            return true;
        }
        return false;
    }

    public boolean isAccessibleAll(List<String> urls) {
        for (String url : urls) {
            if (this.isAccessible(url)) continue;
            return false;
        }
        return true;
    }

    public static UserRolesProxy create(Set<Long> roleIds, FeatureURIManager featureUriManager, Map<Long, Map<String, Map<String, Set<HttpMethod>>>> methodsUriMapByFeatureByRoleId) {
        HashMap<String, Set<HttpMethod>> accessibleMethodsByUri = new HashMap<String, Set<HttpMethod>>();
        for (Long roleId : roleIds) {
            Map<String, Map<String, Set<HttpMethod>>> methodsUriMapByFeature = methodsUriMapByFeatureByRoleId.get(roleId);
            if (methodsUriMapByFeature == null) continue;
            for (Map<String, Set<HttpMethod>> methodsUriMap : methodsUriMapByFeature.values()) {
                for (Map.Entry<String, Set<HttpMethod>> entry : methodsUriMap.entrySet()) {
                    accessibleMethodsByUri.compute(entry.getKey(), (k, v) -> {
                        if (v == null) {
                            return (Set)entry.getValue();
                        }
                        HashSet methods = new HashSet(v);
                        methods.addAll((Collection)entry.getValue());
                        return methods;
                    });
                }
            }
        }
        return UserRolesProxy.builder().featureUriManager(featureUriManager).accessibleMethodsByUri(accessibleMethodsByUri).build();
    }

    @Generated
    UserRolesProxy(FeatureURIManager featureUriManager, Map<String, Set<HttpMethod>> accessibleMethodsByUri) {
        this.featureUriManager = featureUriManager;
        this.accessibleMethodsByUri = accessibleMethodsByUri;
    }

    @Generated
    public static UserRolesProxyBuilder builder() {
        return new UserRolesProxyBuilder();
    }

    @Generated
    public static class UserRolesProxyBuilder {
        @Generated
        private FeatureURIManager featureUriManager;
        @Generated
        private Map<String, Set<HttpMethod>> accessibleMethodsByUri;

        @Generated
        UserRolesProxyBuilder() {
        }

        @Generated
        public UserRolesProxyBuilder featureUriManager(FeatureURIManager featureUriManager) {
            this.featureUriManager = featureUriManager;
            return this;
        }

        @Generated
        public UserRolesProxyBuilder accessibleMethodsByUri(Map<String, Set<HttpMethod>> accessibleMethodsByUri) {
            this.accessibleMethodsByUri = accessibleMethodsByUri;
            return this;
        }

        @Generated
        public UserRolesProxy build() {
            return new UserRolesProxy(this.featureUriManager, this.accessibleMethodsByUri);
        }

        @Generated
        public String toString() {
            return "UserRolesProxy.UserRolesProxyBuilder(featureUriManager=" + this.featureUriManager + ", accessibleMethodsByUri=" + this.accessibleMethodsByUri + ")";
        }
    }
}

