/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.repo;

import com.tvd12.ezydata.jpa.repository.EzyJpaRepository;
import com.tvd12.ezyfox.io.EzyLists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.youngmonkeys.ezyplatform.entity.AdminMeta;
import org.youngmonkeys.ezyplatform.util.Strings;

public class AdminMetaTransactionalRepository
extends EzyJpaRepository<Long, AdminMeta> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAdminMetaUniqueKey(long adminId, String metaKey, String metaValue, String metaTextValue) {
        BigInteger metaNumberValue = Strings.toBigIntegerOrZero(metaValue);
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM AdminMeta e WHERE e.adminId = ?0 AND e.metaKey = ?1").setParameter(0, (Object)adminId).setParameter(1, (Object)metaKey).setMaxResults(1).getResultList();
                AdminMeta entity = (AdminMeta)EzyLists.first((List)entities);
                if (entity == null) {
                    entity = new AdminMeta();
                    entity.setAdminId(adminId);
                    entity.setMetaKey(metaKey);
                }
                entity.setMetaValue(metaValue);
                entity.setMetaNumberValue(metaNumberValue);
                entity.setMetaTextValue(metaTextValue);
                entityManager.merge((Object)entity);
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAdminMetaUniqueKeyValue(long adminId, String metaKey, String metaValue) {
        BigInteger metaNumberValue = Strings.toBigIntegerOrZero(metaValue);
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM AdminMeta e WHERE e.adminId = ?0 AND e.metaKey = ?1 AND e.metaValue = ?2").setParameter(0, (Object)adminId).setParameter(1, (Object)metaKey).setParameter(2, (Object)metaValue).setMaxResults(1).getResultList();
                AdminMeta entity = (AdminMeta)EzyLists.first((List)entities);
                if (entity == null) {
                    entity = new AdminMeta();
                    entity.setAdminId(adminId);
                    entity.setMetaKey(metaKey);
                    entity.setMetaValue(metaValue);
                    entity.setMetaNumberValue(metaNumberValue);
                    entityManager.merge((Object)entity);
                }
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    public BigDecimal increaseMetaValue(long adminId, String metaKey, BigDecimal value) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                List entities = entityManager.createQuery("SELECT e FROM AdminMeta e WHERE e.adminId = ?0 AND e.metaKey = ?1").setParameter(0, (Object)adminId).setParameter(1, (Object)metaKey).setMaxResults(1).getResultList();
                AdminMeta entity = (AdminMeta)EzyLists.first((List)entities);
                BigDecimal currentValue = BigDecimal.ZERO;
                if (entity == null) {
                    entity = new AdminMeta();
                    entity.setAdminId(adminId);
                    entity.setMetaKey(metaKey);
                } else {
                    currentValue = new BigDecimal(entity.getMetaValue());
                }
                BigDecimal newValue = currentValue.add(value);
                entity.setMetaValue(newValue.toString());
                entity.setMetaNumberValue(newValue.toBigInteger());
                entityManager.merge((Object)entity);
                transaction.commit();
                BigDecimal bigDecimal = newValue;
                return bigDecimal;
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    protected Class<AdminMeta> getEntityType() {
        return AdminMeta.class;
    }
}

