/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.io.EzyStrings;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.entity.Admin;
import org.youngmonkeys.ezyplatform.entity.AdminAccessToken;
import org.youngmonkeys.ezyplatform.exception.AdminAccessTokenExpiredException;
import org.youngmonkeys.ezyplatform.exception.AdminInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.exception.AdminWaiting2FaAccessTokenException;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.AvatarCoverImageIdsModel;
import org.youngmonkeys.ezyplatform.model.UuidNameModel;
import org.youngmonkeys.ezyplatform.repo.AdminAccessTokenRepository;
import org.youngmonkeys.ezyplatform.repo.AdminRepository;
import org.youngmonkeys.ezyplatform.result.IdNameResult;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.result.IdUuidNameResult;
import org.youngmonkeys.ezyplatform.result.StatusResult;
import org.youngmonkeys.ezyplatform.service.AdminAccessTokenService;
import org.youngmonkeys.ezyplatform.service.AdminService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

public class DefaultAdminService
implements AdminService {
    private final ClockProxy clock;
    private final AdminAccessTokenService accessTokenService;
    private final AdminRepository adminRepository;
    private final AdminAccessTokenRepository accessTokenRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultResultToModelConverter resultToModelConverter;

    @Override
    public AdminModel getAdminById(long adminId) {
        return this.entityToModelConverter.toModel((Admin)this.adminRepository.findById(adminId));
    }

    @Override
    public Optional<AdminModel> getAdminByIdOptional(long adminId) {
        return this.adminRepository.findByIdOptional(adminId).map(this.entityToModelConverter::toModel);
    }

    @Override
    public AdminModel getAdminByUuid(String uuid) {
        return this.entityToModelConverter.toModel((Admin)this.adminRepository.findByField("uuid", uuid));
    }

    @Override
    public Optional<AdminModel> getAdminByUuidOptional(String uuid) {
        return this.adminRepository.findByFieldOptional("uuid", uuid).map(this.entityToModelConverter::toModel);
    }

    @Override
    public AdminModel getAdminByUsername(String username) {
        return this.entityToModelConverter.toModel((Admin)this.adminRepository.findByField("username", username));
    }

    @Override
    public Optional<AdminModel> getAdminByUsernameOptional(String username) {
        return this.adminRepository.findByFieldOptional("username", username).map(this.entityToModelConverter::toModel);
    }

    @Override
    public AdminNameModel getAdminNameById(long adminId) {
        return this.resultToModelConverter.toAdminNameModel(this.adminRepository.findAdminNameById(adminId));
    }

    @Override
    public Map<Long, AdminNameModel> getAdminNameMapByIds(Collection<Long> adminIds) {
        if (adminIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminRepository.findAdminNamesByIds(adminIds).stream().collect(Collectors.toMap(IdNameResult::getId, this.resultToModelConverter::toAdminNameModel));
    }

    @Override
    public UuidNameModel getAdminUuidNameById(long adminId) {
        return this.resultToModelConverter.toModel(this.adminRepository.findAdminUuidNameById(adminId));
    }

    @Override
    public Map<Long, UuidNameModel> getAdminUuidNameMapByIds(Collection<Long> adminIds) {
        if (adminIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminRepository.findAdminUuidNamesByIds(adminIds).stream().collect(Collectors.toMap(IdUuidNameResult::getId, this.resultToModelConverter::toModel));
    }

    @Override
    public AvatarCoverImageIdsModel getAdminAvatarCoverImageIdsById(long adminId) {
        return this.resultToModelConverter.toModel(this.adminRepository.findAdminAvatarCoverImageIdsById(adminId));
    }

    @Override
    public UuidNameModel getAdminUuidNameByUuid(String uuid) {
        return this.resultToModelConverter.toModel(this.adminRepository.findAdminUuidNameByUuid(uuid));
    }

    @Override
    public Long getAdminIdByUuid(String uuid) {
        IdResult result = this.adminRepository.findAdminIdByUuid(uuid);
        return result != null ? Long.valueOf(result.getId()) : null;
    }

    @Override
    public AdminModel getAdminByAccessToken(String accessToken, Set<String> tokenTypes) {
        long adminId = this.validateAdminAccessToken(accessToken, tokenTypes);
        return this.getAdminById(adminId);
    }

    @Override
    public Long getAdminIdByAccessToken(String accessToken, Set<String> tokenTypes) {
        AdminAccessToken entity;
        if (accessToken != null && (entity = (AdminAccessToken)this.accessTokenRepository.findById(accessToken)) != null && tokenTypes.contains(entity.getTokenType())) {
            return entity.getAdminId();
        }
        return null;
    }

    @Override
    public List<AdminModel> getAdminsByIds(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.adminRepository.findListByIds(ids).stream().map(this.entityToModelConverter::toModel).collect(Collectors.toList());
    }

    @Override
    public List<AdminModel> getAdminsByUuids(Collection<String> uuids) {
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.adminRepository.findByUuidIn(uuids).stream().map(this.entityToModelConverter::toModel).collect(Collectors.toList());
    }

    @Override
    public Map<String, AdminModel> getAdminMapByUuids(Collection<String> uuids) {
        return EzyMaps.newHashMap(this.getAdminsByUuids(uuids), AdminModel::getUuid);
    }

    @Override
    public AdminModel getAdminByEmail(String email) {
        return this.entityToModelConverter.toModel((Admin)this.adminRepository.findByField("email", email));
    }

    @Override
    public AdminModel getAdminByPhone(String phone) {
        return this.adminRepository.findByFieldOptional("phone", phone).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public AdminModel getAdminByUsernameOrEmail(String usernameOrEmail) {
        AdminModel admin = this.getAdminByUsername(usernameOrEmail);
        if (admin == null) {
            admin = this.getAdminByEmail(usernameOrEmail);
        }
        return admin;
    }

    @Override
    public List<String> getAllAdminStatuses() {
        return this.adminRepository.findAllAdminStatuses().stream().map(StatusResult::getStatus).filter(EzyStrings::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public long validateAdminAccessToken(String accessToken, Set<String> tokenTypes) {
        return this.getAccessTokenEntityOrThrowByAccessToken(accessToken, tokenTypes, Boolean.TRUE).getAdminId();
    }

    @Override
    public AdminAccessTokenModel getAdminAccessTokenOrThrowByAccessToken(String accessToken, Set<String> tokenTypes, boolean verifyStatus) {
        return this.entityToModelConverter.toModel(this.getAccessTokenEntityOrThrowByAccessToken(accessToken, tokenTypes, verifyStatus));
    }

    protected AdminAccessToken getAccessTokenEntityOrThrowByAccessToken(String accessToken, Set<String> tokenTypes, boolean verifyStatus) {
        if (EzyStrings.isBlank((String)accessToken)) {
            throw new AdminInvalidAccessTokenException(accessToken);
        }
        long adminId = this.accessTokenService.extractAdminId(accessToken);
        if (adminId <= 0L) {
            throw new AdminInvalidAccessTokenException(accessToken);
        }
        AdminAccessToken entity = (AdminAccessToken)this.accessTokenRepository.findById(accessToken);
        if (entity == null) {
            throw new AdminInvalidAccessTokenException(accessToken);
        }
        String tokenType = entity.getTokenType();
        if (!tokenTypes.isEmpty() && EzyStrings.isBlank((String)tokenType) || !tokenTypes.contains(tokenType)) {
            throw new AdminInvalidAccessTokenException(accessToken);
        }
        if (adminId != entity.getAdminId()) {
            throw new AdminInvalidAccessTokenException(accessToken);
        }
        String status = entity.getStatus();
        if (verifyStatus && !AccessTokenStatus.ACTIVATED.equalsValue(status) && !AccessTokenStatus.ACTIVATED_2FA.equalsValue(status)) {
            if (AccessTokenStatus.WAITING_2FA.equalsValue(status)) {
                throw new AdminWaiting2FaAccessTokenException(accessToken);
            }
            throw new AdminInvalidAccessTokenException(accessToken);
        }
        LocalDateTime now = this.clock.nowDateTime();
        if (now.isAfter(entity.getExpiredAt())) {
            throw new AdminAccessTokenExpiredException(accessToken);
        }
        return entity;
    }

    @Generated
    public DefaultAdminService(ClockProxy clock, AdminAccessTokenService accessTokenService, AdminRepository adminRepository, AdminAccessTokenRepository accessTokenRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultResultToModelConverter resultToModelConverter) {
        this.clock = clock;
        this.accessTokenService = accessTokenService;
        this.adminRepository = adminRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.resultToModelConverter = resultToModelConverter;
    }
}

