/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.Next;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.UserKeyword;
import org.youngmonkeys.ezyplatform.model.AddUserKeywordModel;
import org.youngmonkeys.ezyplatform.repo.UserKeywordRepository;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.service.UserKeywordService;

public class DefaultUserKeywordService
extends EzyLoggable
implements UserKeywordService {
    private final UserKeywordRepository userKeywordRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void addUserKeyword(AddUserKeywordModel model) {
        String keyword;
        long userId = model.getUserId();
        UserKeyword entity = this.userKeywordRepository.findByUserIdAndKeyword(userId, keyword = model.getKeyword());
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(model);
        } else {
            this.modelToEntityConverter.mergeToEntity(model, entity);
        }
        try {
            this.userKeywordRepository.save(entity);
        }
        catch (Exception e) {
            this.logger.info("save keyword: {} of useId: {} failed", (Object)keyword, (Object)userId);
        }
    }

    @Override
    public void addUserKeywords(Collection<AddUserKeywordModel> userKeywords) {
        for (AddUserKeywordModel model : userKeywords) {
            this.addUserKeyword(model);
        }
    }

    @Override
    public void deleteUserKeywordsByUserId(long userId) {
        this.userKeywordRepository.deleteByUserId(userId);
    }

    @Override
    public void deleteUserKeywordsByUserIds(Collection<Long> userIds) {
        if (!userIds.isEmpty()) {
            this.userKeywordRepository.deleteByUserIdIn(userIds);
        }
    }

    @Override
    public boolean containsUserKeyword(long userId, String keyword) {
        return this.userKeywordRepository.findByUserIdAndKeyword(userId, keyword) != null;
    }

    @Override
    public List<Long> getUserIdsByKeywords(Collection<String> keywords, int limit, int maxFetchRound) {
        if (keywords.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> exclusiveUserIds = Collections.singletonList(0L);
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (int fetchedRound = 0; fetchedRound < maxFetchRound && userIds.size() < limit; ++fetchedRound) {
            List fetchedUserIds = this.userKeywordRepository.findUserIdsByKeywordInAndUserIdNotInOrderByPriorityDescIdDesc(keywords, exclusiveUserIds, Next.limit((long)limit)).stream().map(IdResult::getId).distinct().collect(Collectors.toList());
            userIds.addAll(fetchedUserIds);
            exclusiveUserIds = userIds;
            if (fetchedUserIds.size() < limit) break;
        }
        return userIds.size() <= limit ? userIds : userIds.subList(0, limit);
    }

    @Override
    public List<Long> getUserIdsByKeywordPrefix(String keywordPrefix, int limit, int maxFetchRound) {
        if (EzyStrings.isBlank((String)keywordPrefix)) {
            return Collections.emptyList();
        }
        List<Long> exclusiveUserIds = Collections.singletonList(0L);
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (int fetchedRound = 0; fetchedRound < maxFetchRound && userIds.size() < limit; ++fetchedRound) {
            List fetchedUserIds = this.userKeywordRepository.findUserIdsByKeywordPrefixAndUserIdNotInOrderByPriorityDescIdDesc(keywordPrefix, exclusiveUserIds, Next.limit((long)limit)).stream().map(IdResult::getId).distinct().collect(Collectors.toList());
            userIds.addAll(fetchedUserIds);
            exclusiveUserIds = userIds;
            if (fetchedUserIds.size() < limit) break;
        }
        return userIds.size() <= limit ? userIds : userIds.subList(0, limit);
    }

    @Generated
    public DefaultUserKeywordService(UserKeywordRepository userKeywordRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.userKeywordRepository = userKeywordRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

