/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.builder.impl;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.creator.EzySessionCreator;
import com.tvd12.ezyfoxserver.creator.EzySimpleSessionCreator;
import com.tvd12.ezyfoxserver.nio.entity.EzyNioSession;
import com.tvd12.ezyfoxserver.nio.factory.EzyHandlerGroupBuilderFactory;
import com.tvd12.ezyfoxserver.nio.handler.EzyAbstractHandlerGroup;
import com.tvd12.ezyfoxserver.nio.handler.EzySimpleNioHandlerGroup;
import com.tvd12.ezyfoxserver.nio.websocket.EzySimpleWsHandlerGroup;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsRequestQueues;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamQueue;
import com.tvd12.ezyfoxserver.statistics.EzyNetworkStats;
import com.tvd12.ezyfoxserver.statistics.EzySessionStats;
import com.tvd12.ezyfoxserver.statistics.EzySocketStatistics;
import com.tvd12.ezyfoxserver.statistics.EzyStatistics;
import com.tvd12.ezyfoxserver.statistics.EzyWebSocketStatistics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class EzyHandlerGroupBuilderFactoryImpl
implements EzyHandlerGroupBuilderFactory {
    private final ExecutorService statsThreadPool;
    private final EzyStatistics statistics;
    private final AtomicInteger socketSessionCount = new AtomicInteger(0);
    private final AtomicInteger webSocketSessionCount = new AtomicInteger(0);
    private final EzyCodecFactory codecFactory;
    private final EzyServerContext serverContext;
    private final EzySessionCreator sessionCreator;
    private final EzySocketStreamQueue streamQueue;
    private final EzySocketDisconnectionQueue disconnectionQueue;
    private final EzySessionTicketsQueue socketSessionTicketsQueue;
    private final EzySessionTicketsQueue webSocketSessionTicketsQueue;
    private final EzySessionTicketsRequestQueues sessionTicketsRequestQueues;

    public EzyHandlerGroupBuilderFactoryImpl(Builder builder) {
        this.statistics = builder.statistics;
        this.statsThreadPool = builder.statsThreadPool;
        this.streamQueue = builder.streamQueue;
        this.codecFactory = builder.codecFactory;
        this.serverContext = builder.serverContext;
        this.sessionCreator = builder.sessionCreator;
        this.disconnectionQueue = builder.disconnectionQueue;
        this.socketSessionTicketsQueue = builder.socketSessionTicketsQueue;
        this.webSocketSessionTicketsQueue = builder.webSocketSessionTicketsQueue;
        this.sessionTicketsRequestQueues = builder.sessionTicketsRequestQueues;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EzyAbstractHandlerGroup.Builder newBuilder(EzyChannel channel, EzyConnectionType type) {
        EzyAbstractHandlerGroup.Builder builder = type == EzyConnectionType.SOCKET ? this.newBuilderBySocketType() : this.newBuilderByWebSocketType();
        builder.session((EzyNioSession)this.sessionCreator.create(channel));
        builder.serverContext(this.serverContext);
        builder.streamQueue(this.streamQueue);
        builder.disconnectionQueue(this.disconnectionQueue);
        builder.decoder(this.newDataDecoder(type));
        builder.statsThreadPool(this.statsThreadPool);
        builder.sessionTicketsRequestQueues(this.sessionTicketsRequestQueues);
        return builder;
    }

    private EzyAbstractHandlerGroup.Builder newBuilderBySocketType() {
        return EzySimpleNioHandlerGroup.builder().sessionCount(this.socketSessionCount).sessionStats(this.getSocketSessionStats()).networkStats(this.getSocketNetworkStats()).sessionTicketsQueue(this.socketSessionTicketsQueue);
    }

    private EzyAbstractHandlerGroup.Builder newBuilderByWebSocketType() {
        EzySimpleWsHandlerGroup.Builder builder = EzySimpleWsHandlerGroup.builder();
        builder.sessionCount(this.webSocketSessionCount);
        builder.sessionStats(this.getWebSocketSessionStats());
        builder.networkStats(this.getWebSocketNetworkStats());
        builder.sessionTicketsQueue(this.webSocketSessionTicketsQueue);
        return builder;
    }

    private Object newDataDecoder(EzyConnectionType type) {
        return this.codecFactory.newDecoder((EzyConstant)type);
    }

    private EzySessionStats getSocketSessionStats() {
        return (EzySessionStats)this.getSocketStatistics().getSessionStats();
    }

    private EzySessionStats getWebSocketSessionStats() {
        return (EzySessionStats)this.getWebSocketStatistics().getSessionStats();
    }

    private EzyNetworkStats getSocketNetworkStats() {
        return (EzyNetworkStats)this.getSocketStatistics().getNetworkStats();
    }

    private EzyNetworkStats getWebSocketNetworkStats() {
        return (EzyNetworkStats)this.getWebSocketStatistics().getNetworkStats();
    }

    private EzySocketStatistics getSocketStatistics() {
        return this.statistics.getSocketStats();
    }

    private EzyWebSocketStatistics getWebSocketStatistics() {
        return this.statistics.getWebSocketStats();
    }

    public static class Builder
    implements EzyBuilder<EzyHandlerGroupBuilderFactory> {
        private EzyStatistics statistics;
        private ExecutorService statsThreadPool;
        private EzyCodecFactory codecFactory;
        private EzyServerContext serverContext;
        private EzySessionCreator sessionCreator;
        private EzySocketStreamQueue streamQueue;
        private EzySocketDisconnectionQueue disconnectionQueue;
        private EzySessionTicketsQueue socketSessionTicketsQueue;
        private EzySessionTicketsQueue webSocketSessionTicketsQueue;
        private EzySessionTicketsRequestQueues sessionTicketsRequestQueues;

        public Builder statistics(EzyStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public Builder statsThreadPool(ExecutorService statsThreadPool) {
            this.statsThreadPool = statsThreadPool;
            return this;
        }

        public Builder streamQueue(EzySocketStreamQueue streamQueue) {
            this.streamQueue = streamQueue;
            return this;
        }

        public Builder disconnectionQueue(EzySocketDisconnectionQueue disconnectionQueue) {
            this.disconnectionQueue = disconnectionQueue;
            return this;
        }

        public Builder codecFactory(EzyCodecFactory codecFactory) {
            this.codecFactory = codecFactory;
            return this;
        }

        public Builder serverContext(EzyServerContext serverContext) {
            this.serverContext = serverContext;
            return this;
        }

        public Builder sessionCreator(EzySessionCreator sessionCreator) {
            this.sessionCreator = sessionCreator;
            return this;
        }

        public Builder socketSessionTicketsQueue(EzySessionTicketsQueue socketSessionTicketsQueue) {
            this.socketSessionTicketsQueue = socketSessionTicketsQueue;
            return this;
        }

        public Builder webSocketSessionTicketsQueue(EzySessionTicketsQueue webSocketSessionTicketsQueue) {
            this.webSocketSessionTicketsQueue = webSocketSessionTicketsQueue;
            return this;
        }

        public Builder sessionTicketsRequestQueues(EzySessionTicketsRequestQueues sessionTicketsRequestQueues) {
            this.sessionTicketsRequestQueues = sessionTicketsRequestQueues;
            return this;
        }

        public EzyHandlerGroupBuilderFactory build() {
            if (this.sessionCreator == null) {
                this.sessionCreator = this.newSessionCreator(this.serverContext);
            }
            return new EzyHandlerGroupBuilderFactoryImpl(this);
        }

        protected EzySessionCreator newSessionCreator(EzyServerContext serverContext) {
            EzyServer server = serverContext.getServer();
            EzySettings settings = server.getSettings();
            return EzySimpleSessionCreator.builder().sessionManager(server.getSessionManager()).sessionSetting(settings.getSessionManagement()).build();
        }
    }
}

