/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import java.util.Collections;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.data.Menu;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMenuManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.model.AdminProjectModel;
import org.youngmonkeys.ezyplatform.admin.response.ModuleDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminProjectService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminModulesValidator;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.model.AdminModel;

@Api
@Authenticated
@EzyFeature(value="plugin_management")
@Controller(value="/api/v1")
public class AdminApiModulesController {
    private final AdminModuleManager moduleManager;
    private final AdminMenuManager menuManager;
    private final AdminAdminService adminService;
    private final AdminProjectService projectService;
    private final AdminModulesValidator modulesValidator;
    private final AdminModelToResponseConverter modelToResponseConverter;

    @DoGet(value="/modules/{moduleType}/{moduleName}")
    public ModuleDetailsResponse moduleDetailsGet(@PathVariable String moduleTypeName, @PathVariable String moduleName) {
        this.modulesValidator.validateModuleDetailsRequest(moduleTypeName, moduleName);
        ModuleType moduleType = ModuleType.of((String)moduleTypeName);
        Module module = this.moduleManager.getModule(moduleType, moduleName);
        if (module == null) {
            throw new HttpNotFoundException(Collections.singletonMap("module", "notFound"));
        }
        String description = module.getDescription();
        if (EzyStrings.isBlank((String)description)) {
            description = this.moduleManager.getModuleFileContent(moduleType, moduleName, module.getDescriptionFile());
        }
        String settings = this.moduleManager.getModuleFileContent(moduleType, moduleName, module.getSettingsFile());
        Menu menu = this.menuManager.getMenuByModule(moduleName);
        AdminProjectModel project = this.projectService.getProject(moduleName);
        Long updatedAt = project == null ? null : Long.valueOf(project.getUpdatedAt());
        AdminModel updatedBy = project == null ? null : this.adminService.getAdminById(project.getUpdatedByAdminId());
        boolean containsSqlScripts = this.moduleManager.isProjectContainsSqlScripts(moduleName);
        return this.modelToResponseConverter.toResponse(module, containsSqlScripts, menu, description, settings, updatedAt, updatedBy);
    }

    @Generated
    public AdminApiModulesController(AdminModuleManager moduleManager, AdminMenuManager menuManager, AdminAdminService adminService, AdminProjectService projectService, AdminModulesValidator modulesValidator, AdminModelToResponseConverter modelToResponseConverter) {
        this.moduleManager = moduleManager;
        this.menuManager = menuManager;
        this.adminService = adminService;
        this.projectService = projectService;
        this.modulesValidator = modulesValidator;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

