/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.response.ModuleResponse;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;

@Api
@Authenticated
@EzyFeature(value="plugin_management")
@Controller(value="/api/v1")
public class AdminApiPluginsController {
    private final AdminModuleManager moduleManager;
    private final AdminCommonValidator commonValidator;

    @DoGet(value="/modules")
    public Map<String, List<ModuleResponse>> modulesGet(@RequestParam(value="target") String target, @RequestParam(value="active", defaultValue="true") boolean active) {
        ModuleType[] moduleTypes;
        this.commonValidator.validateTarget(target);
        HashMap<String, List<ModuleResponse>> answer = new HashMap<String, List<ModuleResponse>>();
        for (ModuleType moduleType : moduleTypes = this.moduleManager.getModuleTypesByTarget(TargetType.of((String)target))) {
            answer.put(moduleType.getName(), this.moduleManager.getModules(moduleType).stream().filter(it -> it.isActive() == active).map(ModuleResponse::new).collect(Collectors.toList()));
        }
        return answer;
    }

    @Generated
    public AdminApiPluginsController(AdminModuleManager moduleManager, AdminCommonValidator commonValidator) {
        this.moduleManager = moduleManager;
        this.commonValidator = commonValidator;
    }
}

