/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.remover;

import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;

public class AdminDataRemover<I, D>
extends EzyLoggable {
    private final Function<D, I> dataIdExtractor;
    private final AdminSettingService settingService;

    public AdminDataRemover(AdminSettingService settingService) {
        this.settingService = settingService;
        this.dataIdExtractor = this.dataIdExtractor();
    }

    public final void remove() {
        try {
            if (this.isRunnable()) {
                this.doRemove();
            }
        }
        catch (Exception e) {
            this.logger.warn("remove data error", (Throwable)e);
        }
    }

    protected boolean isRunnable() {
        return this.settingService.isMasterServer();
    }

    protected void doRemove() {
        List<D> dataList = this.getDataList();
        if (!dataList.isEmpty()) {
            this.removeDataList(dataList);
        }
    }

    protected void removeDataList(List<D> dataList) {
        Map<I, Object> dataById = dataList.stream().collect(Collectors.toMap(this.dataIdExtractor, it -> it));
        this.removeDataMap(dataById);
    }

    protected void removeDataMap(Map<I, D> dataMap) {
        this.removeDataByIds(dataMap.keySet());
    }

    protected void removeDataByIds(Set<I> dataIds) {
        dataIds.parallelStream().forEach(this::removeDataById);
    }

    private void removeDataById(I dataId) {
        try {
            this.doRemoveDataById(dataId);
        }
        catch (Exception e) {
            this.logger.warn("remove data by id: {} error", dataId, (Object)e);
        }
    }

    protected void doRemoveDataById(I dataId) {
    }

    protected List<D> getDataList() {
        return Collections.emptyList();
    }

    protected Function<D, I> dataIdExtractor() {
        return d -> null;
    }

    public int getPriority() {
        return 0;
    }
}

