/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.List;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.model.AdminMailModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminMailServiceProxy;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.util.Uris;

@Service
public class AdminSpecificMailService {
    private final AdminAdminService adminService;
    private final AdminSettingService settingService;
    private final AdminMailServiceProxy mailServiceProxy;
    private static final int NEW_PLATFORM_RECEIVERS = 3;

    public void sendAddNewAdminMail(String newAdminEmail, String newAdminName) {
        String adminUrl = this.settingService.getAdminUrl();
        String profileUrl = Uris.resolveUrl((String)adminUrl, (String)"admins/me");
        this.mailServiceProxy.send(AdminMailModel.builder().to(newAdminEmail).templateName("admin_new_admin").parameter("adminUrl", (Object)adminUrl).parameter("profileUrl", (Object)profileUrl).title("Welcome, new admin " + newAdminName + "!").content("Hi " + newAdminName + ",<br/><br/>You have become an admin of " + adminUrl + ". Please access <a href=\"" + profileUrl + "\" target=\"_blank\">your profile</a> to review.").build());
    }

    public void sendUpdateAdminPasswordMail(long updateByAdminId, String updatedAdminEmail, String updatedAdminName) {
        this.sendUpdateAdminProfileMail("password", updateByAdminId, updatedAdminEmail, updatedAdminName);
    }

    public void sendUpdateAdminRoles(long updateByAdminId, String updatedAdminEmail, String updatedAdminName) {
        this.sendUpdateAdminProfileMail("roles", updateByAdminId, updatedAdminEmail, updatedAdminName);
    }

    public void sendUpdateAdminProfileMail(long updateByAdminId, String updatedAdminEmail, String updatedAdminName) {
        this.sendUpdateAdminProfileMail("profile", updateByAdminId, updatedAdminEmail, updatedAdminName);
    }

    private void sendUpdateAdminProfileMail(String profileType, long updateByAdminId, String updatedAdminEmail, String updatedAdminName) {
        AdminNameModel updateBy = this.adminService.getAdminNameById(updateByAdminId);
        if (updateBy == null) {
            return;
        }
        String adminUrl = this.settingService.getAdminUrl();
        String profileUrl = Uris.resolveUrl((String)adminUrl, (String)"admins/me");
        this.mailServiceProxy.send(AdminMailModel.builder().to(updatedAdminEmail).templateName("admin_update_profile").parameter("updateByAdminName", (Object)updateBy.getName()).parameter("updateByAdminUsername", (Object)updateBy.getUsername()).parameter("adminUrl", (Object)adminUrl).parameter("profileUrl", (Object)profileUrl).title("Your profile has been updated!").content("Hi " + updatedAdminName + ",<br/><br/>Your " + profileType + " has been updated by admin (" + updateBy.getName() + "). Please access <a href=\"" + profileUrl + "\" target=\"_blank\">Your profile</a> to review.<br/> If you suspect that this is an anomaly, please contact the super admin.").build());
    }

    public void sendResetAdminPasswordMail(long requestByAdminId, String toAdminEmail, String toAdminUsername, String toAdminName, String resetPasswordToken, long tokenExpiredAt) {
        AdminNameModel requestBy = this.adminService.getAdminNameById(requestByAdminId);
        if (requestBy == null) {
            return;
        }
        String adminUrl = this.settingService.getAdminUrl();
        String resetPasswordUrl = Uris.resolveUrl((String)adminUrl, (String)("admins/" + toAdminUsername + "/reset-password?token=" + resetPasswordToken + "&tokenExpiredAt=" + tokenExpiredAt));
        this.mailServiceProxy.send(AdminMailModel.builder().to(toAdminEmail).templateName("admin_reset_password").parameter("requestByAdminName", (Object)requestBy.getName()).parameter("requestByAdminUsername", (Object)requestBy.getUsername()).parameter("adminUrl", (Object)adminUrl).parameter("resetPasswordUrl", (Object)resetPasswordUrl).title("Reset your password").content("Hi " + toAdminName + ",<br/><br/>Your password is required to be reset by admin (" + requestBy.getName() + "). Please access <a href=\"" + resetPasswordUrl + "\" target=\"_blank\">this link</a> to reset.<br/> If you suspect that this is an anomaly, please contact the super admin.").build());
    }

    public void sendNewPlatformVersionMail(String platformVersion) {
        List<AdminModel> superAdmins = this.adminService.getActiveSuperAdmins(3);
        for (AdminModel superAdmin : superAdmins) {
            this.sendNewPlatformVersionMail(platformVersion, superAdmin);
        }
    }

    private void sendNewPlatformVersionMail(String platformVersion, AdminModel receiver) {
        String webUrl = this.settingService.getWebUrl();
        String adminUrl = this.settingService.getAdminUrl();
        String updatePlatformUrl = Uris.resolveUrl((String)adminUrl, (String)"ezyplatform");
        String siteName = this.settingService.getWebSiteName();
        this.mailServiceProxy.send(AdminMailModel.builder().to(receiver.getEmail()).templateName("admin_new_platform_version").parameter("platformVersion", (Object)platformVersion).parameter("webUrl", (Object)"webUrl").parameter("adminUrl", (Object)adminUrl).parameter("updatePlatformUrl", (Object)updatePlatformUrl).parameter("siteName", (Object)siteName).parameter("adminName", (Object)receiver.getName()).title("[" + siteName + "] EzyPlatform " + platformVersion + " is available. Please update!").content("Hi " + receiver.getName() + ",<br/><br/>Please update your site at " + webUrl + " to EzyPlatform " + platformVersion + ".<br/><br/>Updating is easy and only takes a few moments:<br/><a href=\"" + updatePlatformUrl + "\" target=\"_blank\">" + updatePlatformUrl + "</a><br/><br/>Keeping your site updated is important for security. It also makes the internet a safer place for you and your users.<br/><br/>The Young Monkeys Team!").build());
    }

    @Generated
    public AdminSpecificMailService(AdminAdminService adminService, AdminSettingService settingService, AdminMailServiceProxy mailServiceProxy) {
        this.adminService = adminService;
        this.settingService = settingService;
        this.mailServiceProxy = mailServiceProxy;
    }
}

