/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.HashMap;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.exception.AdminAuthenticationException;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminLoginService;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.LoginFailuresModel;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

@EzySingleton
public class AdminAuthenticationValidator {
    private final AdminAdminService adminService;
    private final AdminLoginService adminLoginService;
    private final PasswordManager passwordManager;

    public AdminModel validate(String username, String password) {
        HashMap<String, Object> errors = new HashMap<String, Object>();
        if (!DefaultValidator.isValidUsername((String)username) && !DefaultValidator.isValidEmail((String)username)) {
            errors.put("credential", "invalid");
        }
        if (!DefaultValidator.isValidPassword((String)password)) {
            errors.put("credential", "invalid");
        }
        if (errors.isEmpty()) {
            AdminModel admin = this.adminService.getAdminByUsernameOrEmail(username);
            if (admin == null) {
                errors.put("credential", "invalid");
            } else if (AdminStatus.ACTIVATED.equalsValue(admin.getStatus())) {
                long adminId = admin.getId();
                int blockDuration = this.adminLoginService.getBlockingLoginDurationInMinutes(adminId);
                if (blockDuration > 0) {
                    errors.put("loginBlockDuration", blockDuration);
                } else {
                    boolean isCorrectPassword = this.passwordManager.isMatchingPassword(password, admin.getPassword());
                    if (isCorrectPassword) {
                        this.adminLoginService.cleanLoginFailures(adminId);
                        return admin;
                    }
                    errors.put("credential", "invalid");
                    LoginFailuresModel loginFailures = this.adminLoginService.increaseLoginFailures(adminId);
                    errors.put("loginFailures", loginFailures.getLoginFailures());
                    errors.put("loginBlockDuration", loginFailures.getBlockDuration());
                    errors.put("maxLoginFailures", loginFailures.getMaxLoginFailures());
                }
            } else {
                errors.put("credential", "invalid");
            }
        }
        throw new AdminAuthenticationException(errors);
    }

    @Generated
    public AdminAuthenticationValidator(AdminAdminService adminService, AdminLoginService adminLoginService, PasswordManager passwordManager) {
        this.adminService = adminService;
        this.adminLoginService = adminLoginService;
        this.passwordManager = passwordManager;
    }
}

