/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.pagination.DataIndexFilter;

public class DefaultDataIndexFilter
implements DataIndexFilter {
    public final String dataType;
    public final String keywordPrefix;
    public final Collection<String> keywords;

    protected DefaultDataIndexFilter(Builder<?> builder) {
        this.dataType = ((Builder)builder).dataType;
        this.keywordPrefix = ((Builder)builder).keywordPrefix;
        this.keywords = ((Builder)builder).keywords;
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.dataType != null) {
            answer.and("e.dataType = :dataType");
        }
        if (this.keywordPrefix != null) {
            answer.and("e.keyword LIKE CONCAT(:keywordPrefix,'%')");
        }
        if (this.keywords != null) {
            answer.and("e.keyword in :keywords");
        }
        return answer.build();
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    implements EzyBuilder<DefaultDataIndexFilter> {
        private String dataType;
        private String keywordPrefix;
        private Collection<String> keywords;

        public T dataType(String dataType) {
            this.dataType = dataType;
            return (T)this;
        }

        public T keywordPrefix(String keywordPrefix) {
            this.keywordPrefix = keywordPrefix;
            return (T)this;
        }

        public T keywords(Collection<String> keywords) {
            this.keywords = keywords;
            return (T)this;
        }

        public DefaultDataIndexFilter build() {
            return new DefaultDataIndexFilter(this);
        }
    }
}

