/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyByteToObjectDecoder;
import com.tvd12.ezyfox.codec.EzyCodecCreator;
import com.tvd12.ezyfox.codec.EzyMessageDeserializer;
import com.tvd12.ezyfox.codec.EzyMessageToBytes;
import com.tvd12.ezyfox.codec.EzyObjectToByteEncoder;
import com.tvd12.ezyfox.codec.EzyObjectToMessage;
import com.tvd12.ezyfox.codec.EzySimpleMessageToBytes;
import com.tvd12.ezyfox.codec.MsgPackAesByteToObjectDecoder;
import com.tvd12.ezyfox.codec.MsgPackAesObjectToByteEncoder;
import com.tvd12.ezyfox.codec.MsgPackByteToObjectDecoder;
import com.tvd12.ezyfox.codec.MsgPackObjectToByteEncoder;
import com.tvd12.ezyfox.codec.MsgPackObjectToMessage;
import com.tvd12.ezyfox.codec.MsgPackSimpleDeserializer;

public class MsgPackCodecCreator
implements EzyCodecCreator {
    protected final boolean enableEncryption;
    protected final EzyMessageToBytes messageToBytes;
    protected final EzyObjectToMessage objectToMessage;
    protected final EzyMessageDeserializer deserializer;

    public MsgPackCodecCreator() {
        this(false);
    }

    public MsgPackCodecCreator(boolean enableEncryption) {
        this.enableEncryption = enableEncryption;
        this.messageToBytes = new EzySimpleMessageToBytes();
        this.objectToMessage = new MsgPackObjectToMessage();
        this.deserializer = new MsgPackSimpleDeserializer();
    }

    public EzyByteToObjectDecoder newDecoder(int maxRequestSize) {
        return this.enableEncryption ? new MsgPackAesByteToObjectDecoder(this.deserializer, maxRequestSize) : new MsgPackByteToObjectDecoder(this.deserializer, maxRequestSize);
    }

    public EzyObjectToByteEncoder newEncoder() {
        return this.enableEncryption ? new MsgPackAesObjectToByteEncoder(this.messageToBytes, this.objectToMessage) : new MsgPackObjectToByteEncoder(this.messageToBytes, this.objectToMessage);
    }
}

