/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.ccl;

import com.tvd12.ezyfox.util.EzyDirectories;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzyAppClassLoader
extends URLClassLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EzyAppClassLoader(File directory, ClassLoader parent) {
        super(EzyAppClassLoader.getURLsByPath(directory), parent);
    }

    private static URL[] getURLsByPath(File directory) {
        return EzyAppClassLoader.getURLsByPath(new EzyDirectories().directory(directory));
    }

    private static URL[] getURLsByPath(EzyDirectories directories) {
        try {
            return directories.getURLs();
        }
        catch (Exception e) {
            throw new IllegalStateException("can not load classes from path: " + directories, e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.logger.debug("loadClass({})", (Object)name);
        return super.loadClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.logger.debug("findClass({})", (Object)name);
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        this.logger.info("findResource({})", (Object)name);
        return super.findResource(name);
    }
}

