/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.command.impl;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyExceptionHandlers;
import com.tvd12.ezyfox.util.EzyExceptionHandlersFetcher;
import com.tvd12.ezyfoxserver.EzyApplication;
import com.tvd12.ezyfoxserver.command.EzyAbstractCommand;
import com.tvd12.ezyfoxserver.command.EzyHandleException;

public class EzyAppHandleExceptionImpl
extends EzyAbstractCommand
implements EzyHandleException {
    private final EzyApplication app;
    private final EzyExceptionHandlersFetcher fetcher;

    public EzyAppHandleExceptionImpl(EzyApplication app) {
        this.app = app;
        this.fetcher = (EzyExceptionHandlersFetcher)app;
    }

    @Override
    public void handle(Thread thread, Throwable throwable) {
        String appName = this.app.getSetting().getName();
        EzyExceptionHandlers handlers = this.fetcher.getExceptionHandlers();
        if (handlers.isEmpty()) {
            this.logger.info("app: {} has no handler for exception:", (Object)appName, (Object)throwable);
        } else {
            try {
                handlers.handleException(thread, throwable);
            }
            catch (Exception e) {
                this.logger.warn("handle exception: {} on app: {} error", new Object[]{EzyStrings.exceptionToSimpleString((Throwable)throwable), appName, e});
            }
        }
    }
}

