/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.service;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Objects;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.entity.UserAccessToken;
import org.youngmonkeys.ezyplatform.entity.UserRegisterFrom;
import org.youngmonkeys.ezyplatform.entity.UserStatus;
import org.youngmonkeys.ezyplatform.exception.IncorrectPasswordException;
import org.youngmonkeys.ezyplatform.exception.MediaNotFoundException;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.UserAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.repo.UserAccessTokenRepository;
import org.youngmonkeys.ezyplatform.repo.UserRepository;
import org.youngmonkeys.ezyplatform.service.DefaultUserService;
import org.youngmonkeys.ezyplatform.service.UserAccessTokenService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.Sha256Uuids;
import org.youngmonkeys.ezyplatform.web.converter.WebEntityToModelConverter;
import org.youngmonkeys.ezyplatform.web.converter.WebModelToEntityConverter;
import org.youngmonkeys.ezyplatform.web.converter.WebResultToModelConverter;
import org.youngmonkeys.ezyplatform.web.event.ValidateLoginPasswordEvent;
import org.youngmonkeys.ezyplatform.web.event.WebEventHandlerManager;
import org.youngmonkeys.ezyplatform.web.model.AddUserModel;
import org.youngmonkeys.ezyplatform.web.model.UpdateUserModel;
import org.youngmonkeys.ezyplatform.web.repo.WebUserAccessTokenRepository;
import org.youngmonkeys.ezyplatform.web.repo.WebUserRepository;
import org.youngmonkeys.ezyplatform.web.repo.WebUserRoleRepository;
import org.youngmonkeys.ezyplatform.web.service.WebMediaService;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;
import org.youngmonkeys.ezyplatform.web.service.WebUserAccessTokenService;
import org.youngmonkeys.ezyplatform.web.service.WebUserMetaService;

@Service
public class WebUserService
extends DefaultUserService {
    private final ClockProxy clock;
    private final WebEventHandlerManager eventHandlerManager;
    private final PasswordManager passwordManager;
    private final WebMediaService mediaService;
    private final WebSettingService settingService;
    private final WebUserAccessTokenService userAccessTokenService;
    private final WebUserMetaService userMetaService;
    private final WebUserRepository userRepository;
    private final WebUserAccessTokenRepository userAccessTokenRepository;
    private final WebUserRoleRepository userRoleRepository;
    private final WebEntityToModelConverter entityToModelConverter;
    private final WebModelToEntityConverter modelToEntityConverter;

    public WebUserService(ClockProxy clock, PasswordManager passwordManager, WebEventHandlerManager eventHandlerManager, WebSettingService settingService, WebMediaService mediaService, WebUserAccessTokenService userAccessTokenService, WebUserMetaService userMetaService, WebUserRepository userRepository, WebUserAccessTokenRepository userAccessTokenRepository, WebUserRoleRepository userRoleRepository, WebEntityToModelConverter entityToModelConverter, WebModelToEntityConverter modelToEntityConverter, WebResultToModelConverter resultToModelConverter) {
        super(clock, (UserAccessTokenService)userAccessTokenService, (UserRepository)userRepository, (UserAccessTokenRepository)userAccessTokenRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter, (DefaultResultToModelConverter)resultToModelConverter);
        this.clock = clock;
        this.passwordManager = passwordManager;
        this.eventHandlerManager = eventHandlerManager;
        this.settingService = settingService;
        this.mediaService = mediaService;
        this.userAccessTokenService = userAccessTokenService;
        this.userMetaService = userMetaService;
        this.userRepository = userRepository;
        this.userAccessTokenRepository = userAccessTokenRepository;
        this.userRoleRepository = userRoleRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }

    public UserModel addUserQuickly(AddUserModel model, Collection<Long> roleIds) {
        User entity = this.modelToEntityConverter.toEntity(model);
        this.userRepository.save(entity);
        long userId = entity.getId();
        this.userRoleRepository.save(this.modelToEntityConverter.toUserRoleEntities(userId, roleIds));
        return this.entityToModelConverter.toModel(entity);
    }

    public UserAccessTokenModel addUser(AddUserModel model) {
        User entity = this.modelToEntityConverter.toEntity(model);
        entity.setActivationKey(Sha256Uuids.generateUuid((String)model.getUsername()));
        this.userRepository.save(entity);
        long userId = entity.getId();
        String registerFrom = model.getRegisterFrom();
        this.userMetaService.saveUserMetaUniqueKey(userId, "registerFrom", registerFrom);
        if (EzyStrings.isBlank((String)model.getDisplayName())) {
            this.userMetaService.saveUserMetaUniqueKey(userId, "hasAutoGeneratedName", Boolean.TRUE);
        }
        if (!UserRegisterFrom.NORMAL.toString().equals(registerFrom)) {
            this.userMetaService.saveUserMetaUniqueKey(userId, "hasAutoGeneratedPassword", Boolean.TRUE);
        }
        UserAccessToken accessToken = this.newUserAccessToken(userId, AccessTokenType.ACCESS_TOKEN.toString(), AccessTokenStatus.of((String)model.getStatus()).toString());
        this.userAccessTokenRepository.save(accessToken);
        return this.entityToModelConverter.toModel(accessToken);
    }

    public void activateUser(long userId) {
        User entity = this.getUserEntityByIdOrThrow(userId);
        UserStatus userStatus = UserStatus.valueOf((String)entity.getStatus());
        if (userStatus == UserStatus.INACTIVATED) {
            entity.setStatus(UserStatus.ACTIVATED.name());
            entity.setUpdatedAt(this.clock.nowDateTime());
            this.userRepository.save(entity);
        }
    }

    public void updateUser(UpdateUserModel model) {
        User entity = this.getUserEntityByIdOrThrow(model.getUserId());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.userRepository.save(entity);
    }

    public void updateAvatar(long userId, long avatarId) {
        User entity = this.getUserEntityByIdOrThrow(userId);
        MediaModel media = this.mediaService.getMediaById(avatarId);
        if (media == null || media.getOwnerUserId() != userId) {
            throw new MediaNotFoundException(avatarId);
        }
        entity.setAvatarImageId(avatarId);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void updateCoverImage(long userId, long coverImageId) {
        User entity = this.getUserEntityByIdOrThrow(userId);
        MediaModel media = this.mediaService.getMediaById(coverImageId);
        if (media == null || media.getOwnerUserId() != userId) {
            throw new MediaNotFoundException(coverImageId);
        }
        entity.setCoverImageId(coverImageId);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void updatePassword(long userId, String oldPassword, String newPassword) {
        this.updatePassword(userId, oldPassword, newPassword, Boolean.TRUE);
    }

    public void updatePassword(long userId, String oldPassword, String newPassword, boolean needToResetPassword) {
        User entity = this.getUserEntityByIdOrThrow(userId);
        boolean hasAutoGeneratedPassword = this.isUserHasAutoGeneratedPassword(userId);
        if (!hasAutoGeneratedPassword && needToResetPassword) {
            Boolean result;
            boolean isMatching = this.passwordManager.isMatchingPassword(oldPassword, entity.getPassword());
            if (!isMatching && (result = (Boolean)this.eventHandlerManager.handleEvent(new ValidateLoginPasswordEvent(userId, oldPassword))) != null) {
                isMatching = result;
            }
            if (!isMatching) {
                throw IncorrectPasswordException.ofUserId((long)userId);
            }
        }
        entity.setPassword(this.passwordManager.hashPassword(newPassword));
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
        if (hasAutoGeneratedPassword) {
            this.userMetaService.saveUserMetaUniqueKey(userId, "hasAutoGeneratedPassword", Boolean.FALSE);
        }
    }

    public boolean isUserHasAutoGeneratedPassword(long userId) {
        String value = this.userMetaService.getMetaValueByUserIdAndMetaKey(userId, "hasAutoGeneratedPassword");
        return "true".equals(value);
    }

    public UserModel getUserByActivationKey(String activationKey) {
        if (EzyStrings.isBlank((String)activationKey)) {
            return null;
        }
        return this.entityToModelConverter.toModel((User)this.userRepository.findByField("activationKey", activationKey));
    }

    public UserAccessTokenModel getAccessTokenByToken(String token) {
        if (token == null) {
            return null;
        }
        return this.entityToModelConverter.toModel((UserAccessToken)this.userAccessTokenRepository.findById(token));
    }

    public UserAccessTokenModel getOrCreateAccessTokenByUserId(long userId, String userStatus) {
        return this.getOrCreateAccessTokenByUserId(userId, userStatus, Boolean.TRUE);
    }

    public UserAccessTokenModel getOrCreateAccessTokenByUserId(long userId, String userStatus, boolean needToCheck2Fa) {
        return this.getOrCreateAccessTokenByUserId(userId, AccessTokenType.ACCESS_TOKEN.toString(), userStatus, needToCheck2Fa);
    }

    public UserAccessTokenModel getOrCreateAccessTokenByUserId(long userId, String tokenType, String userStatus, boolean needToCheck2Fa) {
        String accessTokenString;
        long extractedUserId;
        UserAccessToken accessToken = this.userAccessTokenRepository.findByUserIdAndTokenType(userId, tokenType);
        if (accessToken != null && (extractedUserId = this.userAccessTokenService.extractUserId(accessTokenString = accessToken.getId())) != userId) {
            this.userAccessTokenRepository.delete(accessTokenString);
            accessToken = null;
        }
        if (accessToken == null) {
            accessToken = this.newUserAccessToken(userId, tokenType, this.getNewUserAccessTokenStatus(userId, userStatus, needToCheck2Fa));
            this.userAccessTokenRepository.save(accessToken);
        } else {
            LocalDateTime now;
            boolean needToSaveAccessToken = false;
            String accessTokenStatusOld = accessToken.getStatus();
            if (!AccessTokenStatus.ACTIVATED_2FA.equalsValue(accessTokenStatusOld)) {
                String accessTokenStatusNew = this.getNewUserAccessTokenStatus(userId, userStatus, needToCheck2Fa);
                if (AccessTokenStatus.WAITING_2FA.equalsValue(accessTokenStatusNew)) {
                    accessToken = this.newUserAccessToken(userId, tokenType, accessTokenStatusNew);
                    needToSaveAccessToken = true;
                } else if (!Objects.equals(accessTokenStatusNew, accessTokenStatusOld)) {
                    accessToken.setStatus(accessTokenStatusNew);
                    needToSaveAccessToken = true;
                }
            }
            if ((now = this.clock.nowDateTime()).isAfter(accessToken.getExpiredAt())) {
                long extendDays = this.settingService.getUserTokenExpiredTimeInDay();
                accessToken.setExpiredAt(now.plusDays(extendDays));
                needToSaveAccessToken = true;
            }
            if (needToSaveAccessToken) {
                this.userAccessTokenRepository.save(accessToken);
            }
        }
        return this.entityToModelConverter.toModel(accessToken);
    }

    private String getNewUserAccessTokenStatus(long userId, String userStatus, boolean needToCheck2Fa) {
        if (UserStatus.ACTIVATED.equalsValue(userStatus) && needToCheck2Fa && this.isEnable2FaByUserId(userId)) {
            return AccessTokenStatus.WAITING_2FA.toString();
        }
        return AccessTokenStatus.of((String)userStatus).toString();
    }

    public boolean isEnable2FaByUserId(long userId) {
        String value = this.userMetaService.getMetaValueByUserIdAndMetaKey(userId, "enable2FA");
        return "true".equals(value);
    }

    private UserAccessToken newUserAccessToken(long userId, String tokenType, String status) {
        String token = this.userAccessTokenService.generateAccessToken(userId);
        long tokenExpiredTimeInDay = this.settingService.getUserTokenExpiredTimeInDay();
        return this.modelToEntityConverter.toUserAccessTokenEntity(userId, token, tokenType, tokenExpiredTimeInDay, status);
    }
}

