/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.annotation.EzyKeyValue;
import com.tvd12.ezyfox.bean.EzyPrototypeFactory;
import com.tvd12.ezyfox.bean.EzyPrototypeSupplier;
import com.tvd12.ezyfox.bean.annotation.EzyPrototype;
import com.tvd12.ezyfox.bean.impl.EzyBeanKey;
import com.tvd12.ezyfox.bean.impl.EzyBeanNameParser;
import com.tvd12.ezyfox.bean.impl.EzySimpleBeanFactory;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.reflect.EzyClasses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class EzySimplePrototypeFactory
extends EzySimpleBeanFactory
implements EzyPrototypeFactory {
    protected final Set<EzyPrototypeSupplier> supplierSet = new HashSet<EzyPrototypeSupplier>();
    protected final Map<EzyBeanKey, EzyPrototypeSupplier> supplierByKey = new ConcurrentHashMap<EzyBeanKey, EzyPrototypeSupplier>();
    protected final Map<EzyPrototypeSupplier, Map> suppliersByProperties = new ConcurrentHashMap<EzyPrototypeSupplier, Map>();

    @Override
    public EzyPrototypeSupplier getSupplier(Class objectType) {
        return this.getSupplier(this.getBeanName(objectType), objectType);
    }

    @Override
    public EzyPrototypeSupplier getSupplier(String objectName, Class objectType) {
        String realName = this.translateBeanName(objectName, objectType);
        EzyPrototypeSupplier supplier = this.supplierByKey.get(EzyBeanKey.of(realName, objectType));
        if (supplier == null) {
            for (EzyBeanKey key : this.supplierByKey.keySet()) {
                if (!objectType.isAssignableFrom(key.getType())) continue;
                supplier = this.supplierByKey.get(key);
                break;
            }
        }
        return supplier;
    }

    @Override
    public EzyPrototypeSupplier getSupplier(Map properties) {
        for (Map.Entry<EzyPrototypeSupplier, Map> entry : this.suppliersByProperties.entrySet()) {
            if (!EzyMaps.containsAll((Map)entry.getValue(), (Map)properties)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public EzyPrototypeSupplier getAnnotatedSupplier(Class annotationClass) {
        List<EzyPrototypeSupplier> list = this.getSuppliers(annotationClass);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<EzyPrototypeSupplier> getSuppliers() {
        return new ArrayList<EzyPrototypeSupplier>(this.supplierSet);
    }

    @Override
    public List<EzyPrototypeSupplier> getSuppliers(Map properties) {
        HashSet<EzyPrototypeSupplier> set = new HashSet<EzyPrototypeSupplier>();
        for (Map.Entry<EzyPrototypeSupplier, Map> entry : this.suppliersByProperties.entrySet()) {
            if (!EzyMaps.containsAll((Map)entry.getValue(), (Map)properties)) continue;
            set.add(entry.getKey());
        }
        return new ArrayList<EzyPrototypeSupplier>(set);
    }

    @Override
    public List<EzyPrototypeSupplier> getSuppliers(Class ... annotationClasses) {
        return this.getSuppliers((EzyPrototypeSupplier s) -> {
            for (Class annotationClass : annotationClasses) {
                if (!s.getObjectType().isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public List<EzyPrototypeSupplier> getSuppliers(Predicate<EzyPrototypeSupplier> filter) {
        ArrayList<EzyPrototypeSupplier> list = new ArrayList<EzyPrototypeSupplier>();
        for (EzyPrototypeSupplier supplier : this.supplierSet) {
            if (!filter.test(supplier)) continue;
            list.add(supplier);
        }
        return list;
    }

    @Override
    public List<EzyPrototypeSupplier> getSuppliersOf(Class parentClass) {
        return this.getSuppliers((EzyPrototypeSupplier s) -> parentClass.isAssignableFrom(s.getObjectType()));
    }

    @Override
    public Map getProperties(EzyPrototypeSupplier supplier) {
        return this.suppliersByProperties.get(supplier);
    }

    @Override
    public void addSupplier(EzyPrototypeSupplier supplier) {
        Class<?> type = supplier.getObjectType();
        this.addSupplier(this.getBeanName(type), supplier);
    }

    @Override
    public void addSupplier(String objectName, EzyPrototypeSupplier supplier) {
        Class<?> type = supplier.getObjectType();
        this.addSupplier(objectName, supplier, this.getPropertiesByType(type));
    }

    @Override
    public void addSupplier(String objectName, EzyPrototypeSupplier supplier, Map properties) {
        Class<?> type = supplier.getObjectType();
        EzyBeanKey key = EzyBeanKey.of(objectName, type);
        if (this.supplierByKey.containsKey(key)) {
            return;
        }
        this.supplierSet.add(supplier);
        this.supplierByKey.put(key, supplier);
        this.suppliersByProperties.put(supplier, properties);
        String defaultBeanName = this.getDefaultBeanName(type);
        this.mapBeanName(defaultBeanName, type, objectName);
        Set subTypes = EzyClasses.flatSuperAndInterfaceClasses(type, (boolean)true);
        for (Class subType : subTypes) {
            this.checkAndAddSupplier(objectName, subType, supplier);
        }
    }

    private void checkAndAddSupplier(String objectName, Class<?> type, EzyPrototypeSupplier supplier) {
        EzyBeanKey key = EzyBeanKey.of(objectName, type);
        if (this.supplierByKey.containsKey(key)) {
            return;
        }
        this.supplierByKey.put(key, supplier);
    }

    private String getBeanName(Class<?> type) {
        return EzyBeanNameParser.getPrototypeName(type);
    }

    private Map getPropertiesByType(Class<?> type) {
        EzyPrototype ann = type.getAnnotation(EzyPrototype.class);
        HashMap properties = new HashMap();
        EzyKeyValue[] keyValues = ann != null ? ann.properties() : new EzyKeyValue[]{};
        Arrays.stream(keyValues).forEach(kv -> properties.put(kv.key(), kv.value()));
        return properties;
    }
}

