/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;

public class DefaultMediaFilter
implements MediaFilter {
    public final String uploadFrom;
    public final String type;
    public final Collection<String> types;
    public final Long ownerAdminId;
    public final Long ownerUserId;
    public final String prefixKeyword;
    public final String likeKeyword;
    public final String status;
    public final Collection<String> statuses;
    public final String exclusiveStatus;
    public final Boolean publicMedia;

    protected DefaultMediaFilter(Builder<?> builder) {
        this.type = ((Builder)builder).type;
        this.uploadFrom = ((Builder)builder).uploadFrom;
        this.types = ((Builder)builder).types;
        this.ownerAdminId = ((Builder)builder).ownerAdminId;
        this.ownerUserId = ((Builder)builder).ownerUserId;
        this.prefixKeyword = ((Builder)builder).prefixKeyword;
        this.likeKeyword = ((Builder)builder).likeKeyword;
        this.status = ((Builder)builder).status;
        this.statuses = ((Builder)builder).statuses;
        this.exclusiveStatus = ((Builder)builder).exclusiveStatus;
        this.publicMedia = ((Builder)builder).publicMedia;
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.ownerAdminId != null) {
            answer.and("e.ownerAdminId = :ownerAdminId");
        }
        if (this.ownerUserId != null) {
            answer.and("e.ownerUserId = :ownerUserId");
        }
        if (this.uploadFrom != null) {
            answer.and("e.uploadFrom = :uploadFrom");
        }
        if (this.type != null) {
            answer.and("e.type = :type");
        }
        if (this.types != null) {
            answer.and("e.type IN :types");
        }
        if (this.publicMedia != null) {
            answer.and("e.publicMedia = :publicMedia");
        }
        if (this.status != null) {
            answer.and("e.status = :status");
        }
        if (this.statuses != null) {
            answer.and("e.status IN :statuses");
        }
        if (this.exclusiveStatus != null) {
            answer.and("e.status <> :exclusiveStatus");
        }
        if (this.prefixKeyword != null) {
            answer.and("e.originalName LIKE CONCAT(:prefixKeyword,'%')");
        }
        if (this.likeKeyword != null) {
            answer.and("e.originalName LIKE CONCAT('%',:likeKeyword,'%')");
        }
        return answer.build();
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    implements EzyBuilder<DefaultMediaFilter> {
        private String type;
        private String uploadFrom;
        private Collection<String> types;
        private Long ownerAdminId;
        private Long ownerUserId;
        private boolean allowSearchByLikeOperator;
        private String prefixKeyword;
        private String likeKeyword;
        private String status;
        private Collection<String> statuses;
        private String exclusiveStatus;
        private Boolean publicMedia;

        public T type(String type) {
            this.type = type;
            return (T)this;
        }

        public T uploadFrom(String uploadFrom) {
            this.uploadFrom = uploadFrom;
            return (T)this;
        }

        public T types(Collection<String> types) {
            this.types = types;
            return (T)this;
        }

        public T ownerAdminId(Long ownerAdminId) {
            this.ownerAdminId = ownerAdminId;
            return (T)this;
        }

        public T ownerUserId(Long ownerUserId) {
            this.ownerUserId = ownerUserId;
            return (T)this;
        }

        public T allowSearchByLikeOperator(boolean allowSearchByLikeOperator) {
            this.allowSearchByLikeOperator = allowSearchByLikeOperator;
            return (T)this;
        }

        public T prefixKeyword(String prefixKeyword) {
            this.prefixKeyword = prefixKeyword;
            return (T)this;
        }

        public T likeKeyword(String likeKeyword) {
            this.likeKeyword = likeKeyword;
            return (T)this;
        }

        public T status(String status) {
            this.status = status;
            return (T)this;
        }

        public T statuses(Collection<String> statuses) {
            this.statuses = statuses;
            return (T)this;
        }

        public T exclusiveStatus(String exclusiveStatus) {
            this.exclusiveStatus = exclusiveStatus;
            return (T)this;
        }

        public T publicMedia(Boolean publicMedia) {
            this.publicMedia = publicMedia;
            return (T)this;
        }

        public DefaultMediaFilter build() {
            if (this.allowSearchByLikeOperator) {
                this.prefixKeyword = CommonConstants.NULL_STRING;
            } else {
                if (this.likeKeyword != null) {
                    this.prefixKeyword = this.likeKeyword;
                }
                this.likeKeyword = CommonConstants.NULL_STRING;
            }
            return new DefaultMediaFilter(this);
        }
    }
}

