/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.concurrent;

import com.tvd12.ezyfox.function.EzyExceptionSupplier;
import com.tvd12.ezyfox.function.EzyExceptionVoid;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.exception.MaxRetryCountException;

public class Retry<T> {
    private final EzyExceptionSupplier<T> func;
    private final BiConsumer<Integer, Exception> exceptionConsumer;
    private final int maxRetryTime;
    private static final int DEFAULT_MAX_RETRY_TIME = -1;
    private static final int DEFAULT_SLEEP_TIME = 1000;
    private static final int MAX_SLEEP_TIME = 3000;

    public Retry(EzyExceptionSupplier<T> func, BiConsumer<Integer, Exception> exceptionConsumer) {
        this(func, exceptionConsumer, -1);
    }

    public Retry(EzyExceptionVoid func, BiConsumer<Integer, Exception> exceptionConsumer) {
        this(() -> {
            func.apply();
            return Boolean.TRUE;
        }, exceptionConsumer);
    }

    public void run() throws InterruptedException {
        this.get();
    }

    public T get() throws InterruptedException {
        int retryCount = 0;
        while (true) {
            try {
                return (T)this.func.get();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.maxRetryTime > 0 && retryCount >= this.maxRetryTime) {
                    throw new MaxRetryCountException(this.maxRetryTime);
                }
                this.exceptionConsumer.accept(retryCount++, e);
                int sleepTime = Math.min(1000 * retryCount, 3000);
                Thread.sleep(sleepTime);
                continue;
            }
            break;
        }
    }

    public T getOrNull() {
        return this.getOrDefault(null);
    }

    public T getOrDefault(T defaultValue) {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            return defaultValue;
        }
    }

    public T getOrSuppliedValue(Supplier<T> defaultValueSupplier) {
        T value = this.getOrNull();
        return value != null ? value : defaultValueSupplier.get();
    }

    @Generated
    public Retry(EzyExceptionSupplier<T> func, BiConsumer<Integer, Exception> exceptionConsumer, int maxRetryTime) {
        this.func = func;
        this.exceptionConsumer = exceptionConsumer;
        this.maxRetryTime = maxRetryTime;
    }
}

