/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.entity;

import com.tvd12.ezyfox.util.EzyEnums;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import lombok.Generated;

public enum ModuleType {
    THEME("theme", "Theme", "web", "themes"),
    WEB_PLUGIN("web-plugin", "Web Plugin", "web", "plugins"),
    SOCKET_APP("socket-app", "Socket App", "socket", "apps"),
    SOCKET_PLUGIN("socket-plugin", "Socket Plugin", "socket", "plugins"),
    ADMIN_PLUGIN("admin-plugin", "Admin Plugin", "admin", "plugins");

    private final String name;
    private final String displayName;
    private final String parentFolder;
    private final String containerFolder;
    private static final Map<String, ModuleType> MAP;

    private ModuleType(String name, String displayName, String parentFolder, String containerFolder) {
        this.name = name;
        this.displayName = displayName;
        this.parentFolder = parentFolder;
        this.containerFolder = containerFolder;
    }

    public static ModuleType of(String name) {
        return name == null ? null : MAP.get(name);
    }

    public String getTargetFolder() {
        return this.getTargetFolderPath().toString();
    }

    public Path getTargetFolderPath() {
        return Paths.get(this.parentFolder, this.containerFolder);
    }

    public boolean equalsValue(String value) {
        return value != null && this.toString().equals(value);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getParentFolder() {
        return this.parentFolder;
    }

    @Generated
    public String getContainerFolder() {
        return this.containerFolder;
    }

    static {
        MAP = EzyEnums.enumMap(ModuleType.class, it -> it.name);
    }
}

