/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyStrings;
import java.io.File;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.data.ImageSize;
import org.youngmonkeys.ezyplatform.entity.Media;
import org.youngmonkeys.ezyplatform.entity.MediaStatus;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.exception.MediaNotFoundException;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.io.ImageProxy;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.model.AddMediaModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.ReplaceMediaModel;
import org.youngmonkeys.ezyplatform.model.UniqueDataModel;
import org.youngmonkeys.ezyplatform.model.UpdateMediaModel;
import org.youngmonkeys.ezyplatform.repo.MediaRepository;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.result.StatusResult;
import org.youngmonkeys.ezyplatform.result.TypeResult;
import org.youngmonkeys.ezyplatform.service.MediaService;
import org.youngmonkeys.ezyplatform.service.UniqueDataService;

public class DefaultMediaService
implements MediaService {
    private final FileSystemManager fileSystemManager;
    private final UniqueDataService uniqueDataService;
    private final MediaRepository mediaRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public MediaModel addMedia(String uploadFrom, AddMediaModel model) {
        Media entity = this.modelToEntityConverter.toEntity(model, uploadFrom);
        this.mediaRepository.save(entity);
        long mediaId = entity.getId();
        if (model.isSaveDuration()) {
            this.saveMediaDurationInMinutes(mediaId, model.getDurationInMinutes());
        }
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public MediaModel updateMedia(UpdateMediaModel model) {
        Media entity;
        long mediaId = model.getMediaId();
        String mediaName = model.getMediaName();
        Media media = entity = model.getMediaId() > 0L ? (Media)this.mediaRepository.findById(mediaId) : this.mediaRepository.findByNameOrOriginalName(mediaName);
        if (entity == null) {
            throw new MediaNotFoundException(mediaId, mediaName);
        }
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.mediaRepository.save(entity);
        if (model.isUpdateDuration()) {
            this.saveMediaDurationInMinutes(mediaId, model.getDurationInMinutes());
        }
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public MediaModel replaceMedia(ReplaceMediaModel model) {
        Media entity = this.getMediaEntityByIdOrThrow(model.getMediaId());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.mediaRepository.save(entity);
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public void saveMediaDurationInMinutes(long mediaId, BigDecimal duration) {
        this.uniqueDataService.saveDataMeta(UniqueDataModel.builder().dataType("ezy_medias").dataId(mediaId).uniqueKey("durationInMinutes").decimalValue(duration != null ? duration : BigDecimal.ZERO).build());
    }

    @Override
    public void updateMediaOwnerUserIdIfExists(long mediaId, long ownerUserId) {
        Media entity = (Media)this.mediaRepository.findById(mediaId);
        if (entity != null) {
            entity.setOwnerUserId(ownerUserId);
            this.modelToEntityConverter.mergeUpdatedAtToEntity(entity);
            this.mediaRepository.save(entity);
        }
    }

    @Override
    public MediaModel updateMediaStatus(long mediaId, String status) {
        Media entity = this.getMediaEntityByIdOrThrow(mediaId);
        entity.setStatus(status);
        this.modelToEntityConverter.mergeUpdatedAtToEntity(entity);
        this.mediaRepository.save(entity);
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public MediaModel removeMedia(long mediaId) {
        Media entity = this.getMediaEntityByIdOrThrow(mediaId);
        this.removeMediaEntity(entity);
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public MediaModel removeMedia(String mediaName) {
        Media entity = this.getMediaEntityByNameOrThrow(mediaName);
        this.removeMediaEntity(entity);
        return this.entityToModelConverter.toModel(entity);
    }

    private void removeMediaEntity(Media entity) {
        if (MediaStatus.REMOVED.equalsValue(entity.getStatus())) {
            entity.setStatus("DELETED");
            this.mediaRepository.delete(entity.getId());
        } else {
            entity.setStatus(MediaStatus.REMOVED.toString());
            this.modelToEntityConverter.mergeUpdatedAtToEntity(entity);
            this.mediaRepository.save(entity);
        }
    }

    @Override
    public boolean containsMedia(long mediaId) {
        return this.mediaRepository.containsById(mediaId);
    }

    @Override
    public boolean containsMedia(String mediaName) {
        return this.mediaRepository.containsByField("name", mediaName);
    }

    @Override
    public List<String> getAllMediaTypes() {
        return this.mediaRepository.findAllMediaTypes().stream().map(TypeResult::getType).filter(EzyStrings::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllMediaStatuses() {
        return this.mediaRepository.findAllMediaStatuses().stream().map(StatusResult::getStatus).filter(EzyStrings::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public MediaModel getMediaById(long mediaId) {
        return this.entityToModelConverter.toModel((Media)this.mediaRepository.findById(mediaId));
    }

    @Override
    public MediaModel getMediaByName(String mediaName) {
        return this.entityToModelConverter.toModel(this.mediaRepository.findByNameOrOriginalName(mediaName));
    }

    @Override
    public Map<Long, MediaModel> getMediaMapByIds(Collection<Long> mediaIds) {
        if (mediaIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.mediaRepository.findListByIds(mediaIds).stream().collect(Collectors.toMap(Media::getId, this.entityToModelConverter::toModel, (o, n) -> n));
    }

    @Override
    public long getMediaFileLength(MediaType mediaType, String mediaName) {
        long fileLength = this.getMediaFileLengthOrNegative(mediaType, mediaName);
        if (fileLength >= 0L) {
            return fileLength;
        }
        throw new ResourceNotFoundException("media");
    }

    @Override
    public long getMediaFileLengthOrNegative(MediaType mediaType, String mediaName) {
        File mediaFile = this.fileSystemManager.getMediaFilePath(mediaType.getFolder(), mediaName);
        if (mediaFile.exists()) {
            return mediaFile.length();
        }
        return -1L;
    }

    @Override
    public long getMediaFileLengthOrZero(File mediaFile) {
        if (mediaFile.exists()) {
            return mediaFile.length();
        }
        return 0L;
    }

    @Override
    public ImageSize getMediaImageSize(String imageName, MediaType mediaType) {
        ImageSize imageSize = this.getMediaImageSizeOrNull(imageName, mediaType);
        if (imageSize != null) {
            return imageSize;
        }
        throw new ResourceNotFoundException("media");
    }

    @Override
    public ImageSize getMediaImageSize(long mediaId) {
        Media media = (Media)this.mediaRepository.findById(mediaId);
        if (media == null) {
            throw new ResourceNotFoundException("media");
        }
        return this.getMediaImageSize(media.getName(), MediaType.ofName(media.getType()));
    }

    @Override
    public ImageSize getMediaImageSizeOrNull(String imageName, MediaType mediaType) {
        File mediaFile = this.fileSystemManager.getMediaFilePath(mediaType.getFolder(), imageName);
        if (mediaFile.exists()) {
            return ImageProxy.getImageSize(mediaFile);
        }
        return null;
    }

    @Override
    public ImageSize getMediaImageSizeOrDefault(File mediaFile) {
        if (mediaFile.exists()) {
            return ImageProxy.getImageSize(mediaFile);
        }
        return ImageSize.ZERO;
    }

    @Override
    public BigDecimal getMediaDurationInMinutes(long mediaId) {
        return this.uniqueDataService.getUniqueDataValueByDataTypeAndDataIdAndUniqueKey("ezy_medias", mediaId, "durationInMinutes", UniqueDataModel::getDecimalValue, BigDecimal.ZERO);
    }

    @Override
    public Map<Long, BigDecimal> getMediaDurationInMinutesByIds(Collection<Long> mediaIds) {
        return this.uniqueDataService.getUniqueDataValueMapByDataTypeAndDataIdsAndUniqueKey("ezy_medias", mediaIds, "durationInMinutes", UniqueDataModel::getDecimalValue);
    }

    @Override
    public long getOwnerAdminIdByMediaId(long mediaId) {
        IdResult result = this.mediaRepository.findOwnerAdminIdById(mediaId);
        return result != null ? result.getId() : 0L;
    }

    @Override
    public long getOwnerAdminIdByMediaName(String mediaName) {
        IdResult result = this.mediaRepository.findOwnerAdminIdByNameOrOriginalName(mediaName);
        return result != null ? result.getId() : 0L;
    }

    @Override
    public long getOwnerUserIdByMediaId(long mediaId) {
        IdResult result = this.mediaRepository.findOwnerUserIdById(mediaId);
        return result != null ? result.getId() : 0L;
    }

    @Override
    public long getOwnerUserIdByMediaName(String mediaName) {
        IdResult result = this.mediaRepository.findOwnerUserIdByNameOrOriginalName(mediaName);
        return result != null ? result.getId() : 0L;
    }

    protected Media getMediaEntityByIdOrThrow(long mediaId) {
        Media entity = (Media)this.mediaRepository.findById(mediaId);
        if (entity == null) {
            throw new MediaNotFoundException(mediaId);
        }
        return entity;
    }

    protected Media getMediaEntityByNameOrThrow(String mediaName) {
        Media entity = this.mediaRepository.findByNameOrOriginalName(mediaName);
        if (entity == null) {
            throw new MediaNotFoundException(mediaName);
        }
        return entity;
    }

    @Generated
    public DefaultMediaService(FileSystemManager fileSystemManager, UniqueDataService uniqueDataService, MediaRepository mediaRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter) {
        this.fileSystemManager = fileSystemManager;
        this.uniqueDataService = uniqueDataService;
        this.mediaRepository = mediaRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

