/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyhttp.core.constant.HttpMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.RoleFeature;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.repo.RoleFeatureRepository;
import org.youngmonkeys.ezyplatform.service.RoleFeatureService;
import org.youngmonkeys.ezyplatform.service.SettingService;

public class DefaultRoleFeatureService
implements RoleFeatureService {
    protected final String targetType;
    private final RoleFeatureRepository roleFeatureRepository;
    private final AtomicReference<Map<Long, Map<String, Map<String, Set<HttpMethod>>>>> methodsUriMapByFeatureByRoleIdRef = new AtomicReference();

    public DefaultRoleFeatureService(TargetType targetType, SettingService settingService, RoleFeatureRepository roleFeatureRepository) {
        this(targetType.toString(), settingService, roleFeatureRepository);
    }

    public DefaultRoleFeatureService(String targetType, SettingService settingService, RoleFeatureRepository roleFeatureRepository) {
        this.targetType = targetType;
        this.roleFeatureRepository = roleFeatureRepository;
        settingService.watchLastUpdatedTime(CommonConstants.settingNameTargetRoleFeatures(targetType), 1, this::cacheRoleFeatures);
        this.cacheRoleFeaturesIfNull();
    }

    @Override
    public Map<String, Map<String, List<HttpMethod>>> getMethodsUriMapOfFeatureByRoleId(long roleId) {
        return this.getMethodsUriMapOfFeatureByRoleId(this.targetType, roleId);
    }

    @Override
    public Map<String, Map<String, List<HttpMethod>>> getMethodsUriMapOfFeatureByRoleId(TargetType targetType, long roleId) {
        return this.getMethodsUriMapOfFeatureByRoleId(targetType.toString(), roleId);
    }

    @Override
    public Map<String, Map<String, List<HttpMethod>>> getMethodsUriMapOfFeatureByRoleId(String targetType, long roleId) {
        List<RoleFeature> entities = this.roleFeatureRepository.findByRoleIdAndTarget(roleId, targetType);
        HashMap<String, Map<String, List<HttpMethod>>> methodsUriMapOfFeature = new HashMap<String, Map<String, List<HttpMethod>>>();
        for (RoleFeature entity : entities) {
            methodsUriMapOfFeature.computeIfAbsent(entity.getFeature(), k -> new HashMap()).computeIfAbsent(entity.getFeatureUri(), k -> new ArrayList()).add(HttpMethod.valueOf((String)entity.getFeatureMethod()));
        }
        return methodsUriMapOfFeature;
    }

    @Override
    public Map<Long, Map<String, Map<String, Set<HttpMethod>>>> getMethodsUriMapByFeatureByRoleId() {
        return this.methodsUriMapByFeatureByRoleIdRef.get();
    }

    protected void cacheRoleFeatures() {
        HashMap methodsUriMapByFeatureByRoleId = new HashMap();
        this.roleFeatureRepository.findListByField("target", this.targetType).forEach(entity -> methodsUriMapByFeatureByRoleId.computeIfAbsent(entity.getRoleId(), it -> new HashMap()).computeIfAbsent(entity.getFeature(), it -> new HashMap()).computeIfAbsent(entity.getFeatureUri(), it -> new HashSet()).add(HttpMethod.valueOf((String)entity.getFeatureMethod())));
        this.methodsUriMapByFeatureByRoleIdRef.set(methodsUriMapByFeatureByRoleId);
    }

    protected void cacheRoleFeaturesIfNull() {
        if (this.methodsUriMapByFeatureByRoleIdRef.get() == null) {
            this.cacheRoleFeatures();
        }
    }
}

