/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.security.EzyBase64;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.service.UserAccessTokenService;
import org.youngmonkeys.ezyplatform.util.AccessTokens;

public class DefaultUserAccessTokenService
implements UserAccessTokenService {
    private static final AtomicBoolean WATCHED = new AtomicBoolean();
    private static final AtomicReference<byte[]> ENCRYPTION_KEY = new AtomicReference();

    public DefaultUserAccessTokenService(SettingService settingService) {
        if (WATCHED.compareAndSet(false, true)) {
            this.watchLastEncryptionKeyUpdatedTime(settingService);
        }
    }

    private void watchLastEncryptionKeyUpdatedTime(SettingService settingService) {
        settingService.watchLastUpdatedTime("user_access_token_encryption_key", () -> ENCRYPTION_KEY.set(EzyBase64.decode((String)settingService.getDecryptionValue("user_access_token_encryption_key"))));
    }

    @Override
    public String generateAccessToken(long userId) {
        return AccessTokens.generateAccessToken("user", userId, ENCRYPTION_KEY.get());
    }

    @Override
    public long extractUserId(String accessToken) {
        return AccessTokens.extractSourceId(accessToken, ENCRYPTION_KEY.get());
    }
}

