/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.io.EzyStrings;

public final class Uris {
    private Uris() {
    }

    public static String resolveUrl(String root, String path) {
        if (root.endsWith("/")) {
            if (path.startsWith("/")) {
                if (path.length() == 1) {
                    return root;
                }
                return root + path.substring(1);
            }
            return root + path;
        }
        if (path.startsWith("/")) {
            return root + path;
        }
        return root + '/' + path;
    }

    public static boolean uriStartsWith(String uri, String prefix) {
        String compareUri;
        String string = compareUri = prefix.startsWith("/") ? prefix : "/" + prefix;
        if (uri.equals(compareUri)) {
            return true;
        }
        String compareUriPrefix = compareUri + "/";
        return uri.startsWith(compareUriPrefix);
    }

    public static String getSiteName(String siteUrl) {
        return Uris.getSiteName(siteUrl, "");
    }

    public static String getSiteName(String siteUrl, String defaultValue) {
        int colonIndex;
        int slashIndex;
        int dotIndex;
        if (EzyStrings.isBlank((String)siteUrl)) {
            return defaultValue;
        }
        int lastDotIndex = siteUrl.lastIndexOf(46);
        String host = siteUrl;
        if (lastDotIndex > 0) {
            host = host.substring(0, lastDotIndex);
        }
        if ((dotIndex = host.lastIndexOf(46)) >= 0) {
            host = host.substring(dotIndex + 1);
        }
        if ((slashIndex = host.lastIndexOf(47)) >= 0) {
            host = host.substring(slashIndex + 1);
        }
        if ((colonIndex = host.lastIndexOf(58)) >= 0) {
            host = host.substring(0, colonIndex);
        }
        return EzyStrings.toDisplayName((String)host);
    }

    public static String getFileExtensionInUrl(String url) {
        if (EzyStrings.isBlank((String)url)) {
            return null;
        }
        int index = -1;
        int length = url.length();
        for (int i = length - 1; i >= 0; --i) {
            char ch = url.charAt(i);
            if (ch == '.') {
                index = i + 1;
                break;
            }
            if (ch == '/') break;
        }
        return index >= 0 && index < length ? url.substring(index) : null;
    }
}

