/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.security.EzyPlatformDecryptor;
import org.youngmonkeys.ezyplatform.util.Uris;

public abstract class MarketUrlManager {
    protected final EzyLazyInitializer<String> ezyplatformUrl = new EzyLazyInitializer(() -> {
        String marketUrl = (String)beanContext.getProperty((Object)"market.url", String.class, (Object)"https://ezyplatform.com");
        EzyPlatformDecryptor decryptor = (EzyPlatformDecryptor)beanContext.getSingleton(EzyPlatformDecryptor.class);
        try {
            marketUrl = decryptor.decrypt(marketUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return marketUrl;
    });

    public MarketUrlManager(EzyBeanContext beanContext) {
    }

    public String getPlatformGenerateNewKeyUrl(String version) {
        return this.resolveUrl("/api/v1/platforms/" + version + "/generate-new-key");
    }

    public String getSendStartupStatisticsUrl(String platformVersion) {
        return this.resolveUrl("/api/v1/platforms/" + platformVersion + "/targets/" + this.getTargetType().getName() + "/start");
    }

    protected abstract TargetType getTargetType();

    private String resolveUrl(String path) {
        return Uris.resolveUrl((String)((String)this.ezyplatformUrl.get()), (String)path);
    }

    public String getEzyplatformUrl() {
        return (String)this.ezyplatformUrl.get();
    }
}

