/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.math.BigDecimal;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.MediaDetailsModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;

@EzySingleton
public class AdminMediaModelDecorator {
    private final AdminAdminService adminService;
    private final AdminMediaService mediaService;
    private final AdminUserService userService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public AdminMediaDetailsResponse decorate(MediaDetailsModel model) {
        long ownerAdminId = model.getOwnerAdminId();
        long ownerUserId = model.getOwnerUserId();
        AdminNameModel ownerAdmin = this.adminService.getAdminNameById(ownerAdminId);
        UserNameModel ownerUser = this.userService.getUsernameById(ownerUserId);
        BigDecimal duration = this.mediaService.getMediaDurationInMinutes(model.getId());
        return this.modelToResponseConverter.toResponse(model, ownerAdmin, ownerUser, duration);
    }

    @Generated
    public AdminMediaModelDecorator(AdminAdminService adminService, AdminMediaService mediaService, AdminUserService userService, AdminModelToResponseConverter modelToResponseConverter) {
        this.adminService = adminService;
        this.mediaService = mediaService;
        this.userService = userService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

