/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminAdminTokenControllerService;
import org.youngmonkeys.ezyplatform.admin.io.AdminPropertiesFileReader;
import org.youngmonkeys.ezyplatform.admin.io.AdminSocketJsonFileSettingsInteractor;
import org.youngmonkeys.ezyplatform.admin.io.AdminVmOptionsInteractor;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.view.AdminDashboardType;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.entity.TargetType;

@Authenticated
@Controller
@EzyFeature(value="devops")
public class AdminDashboardController {
    private final AdminViewFactory viewFactory;
    private final AdminPropertiesFileReader propertiesFileReader;
    private final AdminSocketJsonFileSettingsInteractor socketFileSettingsInteractor;
    private final AdminVmOptionsInteractor vmOptionsInteractor;
    private final AdminSettingService settingService;
    private final AdminAdminTokenControllerService adminTokenControllerService;

    @DoGet(value="/dashboard/web")
    public View dashboardWebGet(@AdminId long adminId, HttpServletResponse response) {
        this.adminTokenControllerService.setAdminAccessTokenToResponse(response, adminId, AccessTokenType.WEB_MANAGEMENT_TOKEN.toString(), "adminWebManagementAccessToken", "adminWebManagementAccessTokenExpiredAt", Boolean.FALSE);
        return this.viewFactory.newDashboardViewBuilder(AdminDashboardType.WEB).addVariable("webManagementUrl", (Object)this.settingService.getWebManagementUrl()).addVariable("webProperties", (Object)this.propertiesFileReader.readWebConfigContent()).addVariable("webVmOptions", (Object)this.vmOptionsInteractor.readVmOptionsFile(TargetType.WEB)).build();
    }

    @DoGet(value="/dashboard/socket")
    public View dashboardSocketGet(HttpServletResponse response, @AdminId long adminId) {
        Properties properties = this.propertiesFileReader.readSocketConfigProperties();
        this.adminTokenControllerService.setAdminAccessTokenToResponse(response, adminId, AccessTokenType.SOCKET_TOKEN.toString(), "adminSocketAccessToken", "adminSocketAccessTokenExpiredAt", Boolean.FALSE);
        return this.viewFactory.newDashboardViewBuilder(AdminDashboardType.SOCKET).addVariable("socketProperties", (Object)this.propertiesFileReader.readSocketConfigContent()).addVariable("enableWebsocketSsl", (Object)Boolean.parseBoolean(properties.getProperty("websocket.ssl.enable", Boolean.FALSE.toString()))).addVariable("allowSslToReloadAutomatically", (Object)this.settingService.getBooleanValue("socket_auto_reload_ssl_enable", Boolean.TRUE)).addVariable("socketVmOptions", (Object)this.vmOptionsInteractor.readVmOptionsFile(TargetType.SOCKET)).addVariable("socketConfigJson", (Object)this.socketFileSettingsInteractor.readSocketSettings()).build();
    }

    @DoGet(value="/dashboard/admin")
    public View dashboardAdminGet() {
        return this.viewFactory.newDashboardViewBuilder(AdminDashboardType.ADMIN).addVariable("adminUrl", (Object)this.settingService.getAdminUrl()).addVariable("adminProperties", (Object)this.propertiesFileReader.readAdminConfigContent()).addVariable("adminVmOptions", (Object)this.vmOptionsInteractor.readVmOptionsFile(TargetType.ADMIN)).appendValuesToVariable("additionalMessageKeys", (Collection)EzyLists.newArrayList((Object[])AdminStatus.values(), it -> it.toString().toLowerCase())).build();
    }

    @Generated
    public AdminDashboardController(AdminViewFactory viewFactory, AdminPropertiesFileReader propertiesFileReader, AdminSocketJsonFileSettingsInteractor socketFileSettingsInteractor, AdminVmOptionsInteractor vmOptionsInteractor, AdminSettingService settingService, AdminAdminTokenControllerService adminTokenControllerService) {
        this.viewFactory = viewFactory;
        this.propertiesFileReader = propertiesFileReader;
        this.socketFileSettingsInteractor = socketFileSettingsInteractor;
        this.vmOptionsInteractor = vmOptionsInteractor;
        this.settingService = settingService;
        this.adminTokenControllerService = adminTokenControllerService;
    }
}

