/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.annotation.EzyProperty;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.Next;
import com.tvd12.ezyhttp.core.codec.SingletonStringDeserializer;
import com.tvd12.ezyhttp.core.util.FileSizes;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.model.AdminLoginSettingsModel;
import org.youngmonkeys.ezyplatform.admin.model.RegularSettingsModel;
import org.youngmonkeys.ezyplatform.admin.model.SaveSettingModel;
import org.youngmonkeys.ezyplatform.admin.model.SettingModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminSettingRepository;
import org.youngmonkeys.ezyplatform.concurrent.Scheduler;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.repo.SettingRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.rx.RxOperation;
import org.youngmonkeys.ezyplatform.service.MutableSettingService;

@Service
public class AdminSettingService
extends MutableSettingService {
    @EzyProperty(value="server.master")
    private boolean masterServer = Boolean.TRUE;
    private final AdminSettingRepository settingRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private final AdminEntityToModelConverter entityToModelConverter;

    public AdminSettingService(Scheduler scheduler, ObjectMapper objectMapper, AdminFileSystemManager fileSystemManager, AdminSettingRepository settingRepository, AdminModelToEntityConverter modelToEntityConverter, AdminEntityToModelConverter entityToModelConverter) {
        super(scheduler, objectMapper, (FileSystemManager)fileSystemManager, (SettingRepository)settingRepository, (DefaultModelToEntityConverter)modelToEntityConverter);
        this.settingRepository = settingRepository;
        this.modelToEntityConverter = modelToEntityConverter;
        this.entityToModelConverter = entityToModelConverter;
        this.addValueConverter("admin_accepted_media_mime_types", it -> (Set)SingletonStringDeserializer.getInstance().deserialize(it, Set.class, String.class));
        this.scheduleCacheValue("admin_accepted_media_mime_types", 15);
        this.addValueConverter("admin_auto_pass_management_uris", it -> {
            HashSet uris = new HashSet();
            uris.addAll(CommonConstants.DEFAULT_AUTO_PASS_URIS);
            uris.addAll((Collection)SingletonStringDeserializer.getInstance().deserialize(it, Set.class, String.class));
            return uris;
        });
        this.scheduleCacheValue("admin_auto_pass_management_uris", 15);
        this.scheduleCacheValue("ezyplatform_media_up_down_loader_name", 15);
        this.watchLastUpdatedTime("admin_datetime_format", 15, () -> {
            this.cacheValueIfNotNull("admin_date_format", this.getTextValue("admin_date_format"));
            this.cacheValueIfNotNull("admin_time_format", this.getTextValue("admin_time_format"));
            this.cacheValueIfNotNull("admin_datetime_format", this.getTextValue("admin_datetime_format"));
            this.cacheValueIfNotNull("admin_date_minute_format", this.getTextValue("admin_date_minute_format", "YYYY-MM-DD HH:mm"));
        });
    }

    protected void watchEncryptionKeysFile() {
    }

    public void setNodeName(String nodeName) {
        this.setTextValue("ezyplatformNodeName", nodeName);
    }

    public void setPaginationCountLimit(int limit) {
        this.setIntValue("ezyplatform_pagination_count_limit", limit);
    }

    public void setAdminDateFormat(String format) {
        this.setTextValue("admin_date_format", format);
    }

    public void setAdminTimeFormat(String format) {
        this.setTextValue("admin_time_format", format);
    }

    public void setAdminDateTimeFormat(String format) {
        this.setTextValue("admin_datetime_format", format);
    }

    public void setAdminDateMinuteFormat(String format) {
        this.setTextValue("admin_date_minute_format", format);
    }

    public void setWebDateFormat(String format) {
        this.setTextValue("web_date_format", format);
    }

    public void setWebTimeFormat(String format) {
        this.setTextValue("web_time_format", format);
    }

    public void setWebDateTimeFormat(String format) {
        this.setTextValue("web_datetime_format", format);
    }

    public void setWebDateMinuteFormat(String format) {
        this.setTextValue("web_date_minute_format", format);
    }

    public void setAdminUrl(String webUrl) {
        this.setUrlValue("admin_url", webUrl);
    }

    public void setWebUrl(String webUrl) {
        this.setUrlValue("web_url", webUrl);
    }

    public void setWebManagementUrl(String webManagementUrl) {
        this.setUrlValue("web_management_url", webManagementUrl);
    }

    public void setWebSocketUrl(String webSocketUrl) {
        this.setUrlValue("websocket_url", webSocketUrl);
    }

    public void savePasswordValue(String settingName, String passwordValue) {
        this.saveSetting(SaveSettingModel.builder().name(settingName).value(passwordValue).dataType(DataType.PASSWORD).build());
    }

    public void saveEncryptionValue(SaveSettingModel model) {
        this.saveSetting(this.doEncryptModelValue(model));
    }

    public void saveSetting(SaveSettingModel model) {
        Setting setting;
        SaveSettingModel actualModel = this.toEncryptedValueModel(model);
        Setting setting2 = setting = actualModel.getId() > 0L ? (Setting)this.settingRepository.findById(actualModel.getId()) : (Setting)this.settingRepository.findByField("name", actualModel.getName());
        if (setting == null) {
            setting = this.modelToEntityConverter.toEntity(actualModel);
        } else {
            this.modelToEntityConverter.mergeToEntity(actualModel, setting);
        }
        this.settingRepository.save(setting);
    }

    public SettingModel addNewSetting(SaveSettingModel model) {
        SaveSettingModel actualModel = this.toEncryptedValueModel(model);
        Setting setting = this.modelToEntityConverter.toEntity(actualModel);
        this.settingRepository.save(setting);
        return this.entityToModelConverter.toModel(setting);
    }

    public void addNewSettingIfNotExists(SaveSettingModel model) {
        this.addNewSettingIfNotExists(model, false);
    }

    public void addNewSettingIfNotExists(SaveSettingModel model, boolean setLastUpdateTimeIfNotExists) {
        Setting setting;
        Setting setting2 = setting = model.getId() > 0L ? (Setting)this.settingRepository.findById(model.getId()) : (Setting)this.settingRepository.findByField("name", model.getName());
        if (setting == null) {
            setting = this.modelToEntityConverter.toEntity(model);
            this.settingRepository.save(setting);
            if (setLastUpdateTimeIfNotExists) {
                this.setLastUpdateTime(model.getName());
            }
        }
    }

    public long countAllSettings() {
        return this.settingRepository.count();
    }

    public List<SettingModel> getAllSettings() {
        return EzyLists.newArrayList((Collection)this.settingRepository.findAll(), this.entityToModelConverter::toModel);
    }

    public long getAdminTokenExpiredTimeInDay() {
        return this.getLongValue("admin_token_expired_in_day", 7L);
    }

    public boolean isAdminAccessTokenHttpOnly() {
        return this.getBooleanValue("admin_access_token_http_only", Boolean.TRUE);
    }

    public long getMaxUploadFileSize() {
        String value = this.getTextValue("admin_max_upload_file_size", "5MB");
        try {
            return FileSizes.toByteSize((String)value);
        }
        catch (Exception e) {
            return FileSizes.toByteSize((String)"5MB");
        }
    }

    public Set<String> getAcceptedMediaMimeTypes() {
        return (Set)this.getCachedValue("admin_accepted_media_mime_types", CommonConstants.DEFAULT_ACCEPTED_IMAGE_TYPES);
    }

    public long getMaxProjectBundleFileSize() {
        String value = this.getTextValue("max_project_bundle_file_size", "100MB");
        try {
            return FileSizes.toByteSize((String)value);
        }
        catch (Exception e) {
            return FileSizes.toByteSize((String)"100MB");
        }
    }

    public String getAdminUrl() {
        return this.getTextValue("admin_url");
    }

    public Set<String> getAutoPassManagementUris() {
        return (Set)this.getCachedValue("admin_auto_pass_management_uris", CommonConstants.DEFAULT_AUTO_PASS_URIS);
    }

    public String getAdminEzyPlatformLogoUrl() {
        return this.getTextValue("admin_ezyplatform_log_url");
    }

    public String getAdminEzyPlatformCopyright() {
        return this.getTextValue("admin_ezyplatform_copyright");
    }

    public void saveRegularSettings(RegularSettingsModel model) {
        this.setBooleanValue("allow_send_statistics_data", model.isAllowSendStatisticsData());
    }

    public RegularSettingsModel getRegularSettings() {
        return RegularSettingsModel.builder().allowSendStatisticsData(this.isAllowSendStatisticsData()).build();
    }

    public void saveAdminLoginSettings(AdminLoginSettingsModel model) {
        this.setIntValue("admin_max_login_failures", model.getMaxLoginFailures());
        this.setIntValue("admin_login_failure_block_durations", model.getLoginFailureBlockDuration());
    }

    public RxOperation getAdminLoginSettings() {
        return Reactive.multiple().register((Object)"admin_max_login_failures", () -> this.getIntValue("admin_max_login_failures")).register((Object)"admin_login_failure_block_durations", () -> this.getIntValue("admin_login_failure_block_durations")).mapBegin(map -> {
            int maxLoginFailures = (Integer)map.get((Object)"admin_max_login_failures");
            int blockDuration = (Integer)map.get((Object)"admin_login_failure_block_durations");
            return AdminLoginSettingsModel.builder().maxLoginFailures(maxLoginFailures > 0 ? Integer.valueOf(maxLoginFailures) : null).loginFailureBlockDuration(blockDuration > 0 ? Integer.valueOf(blockDuration) : null).build();
        });
    }

    public int getAdminMaxLoginFailures() {
        return this.getIntValue("admin_max_login_failures");
    }

    public long getAdminResetPasswordTokenExpiredInDay() {
        return this.getLongValue("admin_reset_password_token_expired_in_day", 1L);
    }

    public void setAdminAllowSearchUserByLikeOperator(boolean value) {
        this.setBooleanValue("admin_allow_search_user_by_like_operator", value);
    }

    public boolean isAllowSearchUserByLikeOperator() {
        return this.getBooleanValue("admin_allow_search_user_by_like_operator", Boolean.TRUE);
    }

    public void setAdminAllowSearchMediaByLikeOperator(boolean value) {
        this.setBooleanValue("admin_allow_search_media_by_like_operator", value);
    }

    public boolean isAllowSearchMediaByLikeOperator() {
        return this.getBooleanValue("admin_allow_search_media_by_like_operator", Boolean.TRUE);
    }

    public void setWebAllowSearchUserByLikeOperator(boolean value) {
        this.setBooleanValue("web_allow_search_user_by_like_operator", value);
    }

    public void setWebAllowSearchMediaByLikeOperator(boolean value) {
        this.setBooleanValue("web_allow_search_media_by_like_operator", value);
    }

    public void setAdminSsoAllowedOrigins(Map<String, String> origins) {
        HashMap<String, String> originByCookieDomain = new HashMap<String, String>(this.getDefaultAdminSsoAllowedOrigins());
        originByCookieDomain.putAll(origins);
        this.setObjectValue("admin_sso_allowed_origins", originByCookieDomain);
    }

    public boolean isWebAllowSearchUserByLikeOperator() {
        return this.getBooleanValue("web_allow_search_user_by_like_operator", Boolean.TRUE);
    }

    public boolean isWebAllowSearchMediaByLikeOperator() {
        return this.getBooleanValue("web_allow_search_media_by_like_operator", Boolean.TRUE);
    }

    public void setNumberOfMediaPerPage(int value) {
        this.setIntValue("admin_number_of_media_per_page", value);
    }

    public int getNumberOfMediaPerPage() {
        return this.getIntValue("admin_number_of_media_per_page", 30);
    }

    public String getAdminDateFormat() {
        return (String)this.getCachedValue("admin_date_format", "YYYY-MM-DD");
    }

    public String getAdminTimeFormat() {
        return (String)this.getCachedValue("admin_time_format", "HH:mm:ss");
    }

    public String getAdminDateTimeFormat() {
        return (String)this.getCachedValue("admin_datetime_format", "YYYY-MM-DD HH:mm:ss");
    }

    public String getAdminDateMinuteFormat() {
        return (String)this.getCachedValue("admin_date_minute_format", "YYYY-MM-DD HH:mm");
    }

    public boolean isAllowReloadDataAppender() {
        return this.getBooleanValue("admin_allow_reload_data_appender");
    }

    public void setAllowReloadDataAppender(boolean allow) {
        this.setBooleanValue("admin_allow_reload_data_appender", allow);
    }

    public String getAdminSsoAllowedOriginsText() {
        return this.getAdminSsoAllowedOrigins().entrySet().stream().map(it -> (String)it.getKey() + ":" + (String)it.getValue()).collect(Collectors.joining("\n"));
    }

    public Map<String, String> getAdminSsoAllowedOrigins() {
        Map<String, String> originByCookieDomain = (Map<String, String>)this.getObjectValue("admin_sso_allowed_origins", Map.class);
        if (originByCookieDomain == null || originByCookieDomain.isEmpty()) {
            originByCookieDomain = this.getDefaultAdminSsoAllowedOrigins();
        }
        return originByCookieDomain;
    }

    private Map<String, String> getDefaultAdminSsoAllowedOrigins() {
        String host;
        URI uri2;
        HashMap<String, String> originByCookieDomain = new HashMap<String, String>();
        originByCookieDomain.put("localhost", "localhost");
        try {
            uri2 = new URI(this.getWebUrl());
            host = uri2.getHost();
            originByCookieDomain.put(host, host);
        }
        catch (Exception uri2) {
            // empty catch block
        }
        try {
            uri2 = new URI(this.getAdminUrl());
            host = uri2.getHost();
            originByCookieDomain.put(host, host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return originByCookieDomain;
    }

    private SaveSettingModel toEncryptedValueModel(SaveSettingModel origin) {
        if (!DataType.PASSWORD.equalsValue(origin.getDataType())) {
            return origin;
        }
        return this.doEncryptModelValue(origin);
    }

    private SaveSettingModel doEncryptModelValue(SaveSettingModel origin) {
        try {
            return SaveSettingModel.builder().id(origin.getId()).name(origin.getName()).value(this.encryptValue((String)origin.getValue())).dataType(origin.getDataType()).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void changeEncryptionKey(String newEncryptionKey, boolean reEncrypt) {
        FolderProxy.createNewFile((File)this.encryptionKeysFile);
        if (!this.encryptionKeysFile.canWrite()) {
            throw FilePermissionException.fromFileAction((File)this.encryptionKeysFile, (String)"write");
        }
        String oldEncryptionKey = this.getEncryptionKey();
        if (reEncrypt) {
            long lastId = 0L;
            int limit = 100;
            while (true) {
                List<Setting> passwordEntities = this.settingRepository.findByDataTypeAndIdGtOrderByIdAsc(DataType.PASSWORD.toString(), lastId, Next.limit((long)limit));
                for (Setting entity : passwordEntities) {
                    if (EzyStrings.isBlank((String)entity.getValue())) continue;
                    String oldPasswordValue = this.decryptValue(entity.getValue(), oldEncryptionKey);
                    String newEncryptedValue = this.encryptValue(oldPasswordValue, newEncryptionKey);
                    entity.setValue(newEncryptedValue);
                    this.logger.info("re-encrypted setting: {}", (Object)entity.getName());
                }
                this.settingRepository.save(passwordEntities);
                if (passwordEntities.size() < limit) break;
                lastId = ((Setting)EzyLists.last(passwordEntities)).getId();
            }
        }
        this.encryptionKey.set(newEncryptionKey);
        try {
            Files.write(this.encryptionKeysFile.toPath(), Arrays.asList(newEncryptionKey, oldEncryptionKey), new OpenOption[0]);
        }
        catch (IOException e) {
            throw FilePermissionException.fromFileAction((File)this.encryptionKeysFile, (String)"write");
        }
    }

    public void setDataCountAppenderStarted(boolean value) {
        this.setBooleanValue("admin_data_count_appender_started", value);
    }

    public boolean isDataCountAppenderStarted() {
        return this.getBooleanValue("admin_data_count_appender_started", Boolean.TRUE);
    }

    public String getMediaUpDownloaderName() {
        return (String)this.getCachedValue("ezyplatform_media_up_down_loader_name");
    }

    @Generated
    public boolean isMasterServer() {
        return this.masterServer;
    }

    @Generated
    public void setMasterServer(boolean masterServer) {
        this.masterServer = masterServer;
    }
}

