/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.controller;

import com.tvd12.ezyfoxserver.EzyApplication;
import com.tvd12.ezyfoxserver.app.EzyAppRequestController;
import com.tvd12.ezyfoxserver.constant.EzyRequestAppError;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.controller.EzyAbstractServerController;
import com.tvd12.ezyfoxserver.controller.EzyServerController;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzySimpleUserRequestAppEvent;
import com.tvd12.ezyfoxserver.event.EzyUserRequestAppEvent;
import com.tvd12.ezyfoxserver.request.EzyRequestAppParams;
import com.tvd12.ezyfoxserver.request.EzyRequestAppRequest;
import com.tvd12.ezyfoxserver.response.EzyErrorParams;
import com.tvd12.ezyfoxserver.response.EzyRequestAppErrorResponse;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.wrapper.EzyAppUserManager;

public class EzyRequestAppController
extends EzyAbstractServerController
implements EzyServerController<EzyRequestAppRequest> {
    @Override
    public void handle(EzyServerContext ctx, EzyRequestAppRequest request) {
        EzyUser user;
        EzyRequestAppParams params = (EzyRequestAppParams)request.getParams();
        EzyAppContext appCtx = ctx.getAppContext(params.getAppId());
        EzyApplication app = appCtx.getApp();
        EzyAppRequestController requestController = app.getRequestController();
        EzyAppUserManager userManger = appCtx.getApp().getUserManager();
        boolean hasAccessed = userManger.containsUser(user = request.getUser());
        if (hasAccessed) {
            EzyUserRequestAppEvent event = this.newRequestAppEvent(request);
            requestController.handle(appCtx, event);
        } else {
            EzySession session = request.getSession();
            this.responseRequestAppError(ctx, session);
        }
    }

    protected EzyUserRequestAppEvent newRequestAppEvent(EzyRequestAppRequest request) {
        return new EzySimpleUserRequestAppEvent(request.getUser(), request.getSession(), ((EzyRequestAppParams)request.getParams()).getData());
    }

    protected EzyResponse newRequestAppErrorResponse() {
        EzyErrorParams params = new EzyErrorParams();
        params.setError(EzyRequestAppError.HAS_NOT_ACCESSED);
        return new EzyRequestAppErrorResponse(params);
    }

    protected void responseRequestAppError(EzyServerContext ctx, EzySession session) {
        EzyResponse response = this.newRequestAppErrorResponse();
        ctx.send(response, session, false);
    }
}

