/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Collection;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.controller.decorator.AdminUserDecorator;
import org.youngmonkeys.ezyplatform.admin.pagination.AdminUserPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.admin.response.UserResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminPaginationUserService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.controller.service.UserControllerService;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultUserFilter;
import org.youngmonkeys.ezyplatform.pagination.UserPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.service.PaginationUserService;

@Service
public class AdminUserControllerService
extends UserControllerService {
    private final AdminSettingService settingService;
    private final AdminUserService userService;
    private final AdminUserDecorator userDecorator;

    public AdminUserControllerService(AdminSettingService settingService, AdminUserService userService, AdminPaginationUserService paginationUserService, AdminUserPaginationParameterConverter userPaginationParameterConverter, AdminUserDecorator userDecorator) {
        super((PaginationUserService)paginationUserService, (UserPaginationParameterConverter)userPaginationParameterConverter);
        this.settingService = settingService;
        this.userService = userService;
        this.userDecorator = userDecorator;
    }

    public List<UserResponse> getUserListByIds(Collection<Long> userIds) {
        return this.userDecorator.decorateToUserResponses(this.userService.getUserListByIds(userIds));
    }

    public PaginationModel<UserResponse> getUserResponsePagination(String keyword, DefaultUserFilter.Builder<?> filterBuilder, String sortOrder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        PaginationModel<UserModel> pagination = this.getUserPagination(keyword, filterBuilder, sortOrder, nextPageToken, prevPageToken, lastPage, limit);
        return this.userDecorator.decorateToUserResponsePagination(pagination);
    }

    public PaginationModel<UserRoleMemberResponse> getUserRoleMemberPagination(long roleId, String keyword, DefaultUserFilter.Builder<?> filterBuilder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        PaginationModel<UserModel> pagination = this.getUserPagination(keyword, filterBuilder, nextPageToken, prevPageToken, lastPage, limit);
        return this.userDecorator.decorateToUserRoleMemberResponsePagination(pagination, roleId);
    }

    public PaginationModel<UserModel> getUserPagination(String keyword, DefaultUserFilter.Builder<?> filterBuilder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getUserPagination(keyword, filterBuilder, CommonConstants.NULL_STRING, nextPageToken, prevPageToken, lastPage, limit);
    }

    public PaginationModel<UserModel> getUserPagination(String keyword, DefaultUserFilter.Builder<?> filterBuilder, String sortOrder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getUserPagination(keyword, this.settingService.isAllowSearchUserByLikeOperator(), filterBuilder, sortOrder, nextPageToken, prevPageToken, lastPage, limit);
    }
}

