/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminSocketJsonFileSettingsInteractor
extends EzyLoggable {
    private static final Path SOCKET_SETTINGS_FILE = Paths.get(TargetType.SOCKET.getName(), "settings", "ezy-settings.json");
    private final AdminFileSystemManager fileSystemManager;

    public String readSocketSettings() {
        File socketSettingsFile = this.getSocketSettingsFile();
        if (!socketSettingsFile.exists()) {
            return "";
        }
        try {
            return new String(Files.readAllBytes(socketSettingsFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.warn("read socket settings file failed: {}", (Object)socketSettingsFile, (Object)e);
            return "";
        }
    }

    public void writeSocketSettings(String content) {
        File socketSettingsFile = this.getSocketSettingsFile();
        FolderProxy.createNewFile((File)socketSettingsFile);
        try {
            Files.write(socketSettingsFile.toPath(), content == null ? new byte[]{} : content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw FilePermissionException.fromFileAction((File)socketSettingsFile, (String)"write", (Exception)e);
        }
    }

    private File getSocketSettingsFile() {
        return this.fileSystemManager.concatWithEzyHome(SOCKET_SETTINGS_FILE);
    }

    @Generated
    public AdminSocketJsonFileSettingsInteractor(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

