/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.youngmonkeys.ezyplatform.admin.request.AddSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddWebLanguageRequest;
import org.youngmonkeys.ezyplatform.admin.request.ChangeAccessTokenEncryptionKeyRequest;
import org.youngmonkeys.ezyplatform.admin.request.ChangeEncryptionKeyRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAccessTokenExpirationTimeRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAdminLoginSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRegularSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveSocketConfigurationRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveWebsiteSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SettingsDecryptionRequest;
import org.youngmonkeys.ezyplatform.admin.request.SettingsEncryptionRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminUrlRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdatePropertiesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebLanguageRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebUrlsRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebsocketUrlRequest;
import org.youngmonkeys.ezyplatform.admin.service.AdminLanguageService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.ScheduleType;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.model.WebLanguageModel;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

@EzySingleton
public class AdminSettingsValidator {
    private final ObjectMapper objectMapper;
    private final AdminSettingService settingService;
    private final AdminLanguageService adminLanguageService;
    private final Map<String, Function<String, Boolean>> settingValueValidators;

    public AdminSettingsValidator(ObjectMapper objectMapper, AdminSettingService settingService, AdminLanguageService adminLanguageService) {
        this.objectMapper = objectMapper;
        this.settingService = settingService;
        this.adminLanguageService = adminLanguageService;
        this.settingValueValidators = new HashMap<String, Function<String, Boolean>>();
        this.settingValueValidators.put(DataType.BOOLEAN.toString(), DefaultValidator::isBoolean);
        this.settingValueValidators.put(DataType.EMAIL.toString(), DefaultValidator::isValidEmail);
        this.settingValueValidators.put(DataType.FLOAT.toString(), DefaultValidator::isFloatNumber);
        this.settingValueValidators.put(DataType.INTEGER.toString(), DefaultValidator::isIntegerNumber);
        this.settingValueValidators.put(DataType.JSON.toString(), value -> {
            try {
                objectMapper.readTree(value);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        });
        this.settingValueValidators.put(DataType.LONG.toString(), DefaultValidator::isIntegerNumber);
        this.settingValueValidators.put(DataType.URL.toString(), DefaultValidator::isValidUrl);
    }

    public void validate(SaveRegularSettingsRequest request) {
        ScheduleType newPlatformMailScheduleType = request.getNewPlatformMailScheduleType();
        HashMap<String, String> errors = new HashMap<String, String>();
        String defaultLanguageCode = request.getDefaultAdminLanguage();
        if (EzyStrings.isNotBlank((String)defaultLanguageCode) && !this.adminLanguageService.containsLanguage(defaultLanguageCode)) {
            errors.put("defaultAdminLanguage", "invalid");
        }
        if (newPlatformMailScheduleType == null) {
            errors.put("newPlatformMailScheduleType", "required");
        } else if (newPlatformMailScheduleType != ScheduleType.DAYS && newPlatformMailScheduleType != ScheduleType.WEEKS && newPlatformMailScheduleType != ScheduleType.MONTHS && newPlatformMailScheduleType != ScheduleType.NEVER) {
            errors.put("newPlatformMailScheduleType", "invalid");
        }
        int numberOfMediaPerPage = request.getNumberOfMediaPerPage();
        if (numberOfMediaPerPage == 0) {
            errors.put("numberOfMediaPerPage", "required");
        } else if (numberOfMediaPerPage < 0) {
            errors.put("numberOfMediaPerPage", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SaveAdminLoginSettingsRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        Integer maxLoginFailures = request.getMaxLoginFailures();
        Integer loginFailureBlockDuration = request.getLoginFailureBlockDuration();
        if (maxLoginFailures != null) {
            if (maxLoginFailures <= 0) {
                errors.put("maxLoginFailures", "invalid");
            }
            if (loginFailureBlockDuration == null) {
                errors.put("loginFailureBlockDuration", "required");
            }
        }
        if (loginFailureBlockDuration != null && loginFailureBlockDuration <= 0) {
            errors.put("loginFailureBlockDuration", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SaveWebsiteSettingsRequest request) {
        String websiteTagLine;
        String pageTitleSeparator;
        HashMap<String, String> errors = new HashMap<String, String>();
        String websiteTitle = request.getWebsiteTitle();
        if (EzyStrings.isNotBlank((String)websiteTitle) && websiteTitle.length() > 60) {
            errors.put("websiteTitle", "overLength");
        }
        if (EzyStrings.isNotBlank((String)(pageTitleSeparator = request.getPageTitleSeparator())) && pageTitleSeparator.length() > 12) {
            errors.put("pageTitleSeparator", "overLength");
        }
        if (EzyStrings.isNotBlank((String)(websiteTagLine = request.getWebsiteTagLine())) && websiteTagLine.length() > 120) {
            errors.put("websiteTagLine", "overLength");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(AddSettingRequest request) {
        String value;
        HashMap<String, String> errors = new HashMap<String, String>();
        String name = request.getName();
        if (EzyStrings.isBlank((String)name)) {
            errors.put("name", "required");
        } else if (this.settingService.containSetting(name)) {
            errors.put("name", "duplicated");
        }
        String dataType = request.getDataType();
        if (EzyStrings.isBlank((String)dataType)) {
            errors.put("dataType", "required");
        }
        if (EzyStrings.isBlank((String)(value = request.getValue()))) {
            errors.put("value", "required");
        } else if (this.isInvalidSettingValue(dataType, value)) {
            errors.put("value", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateSettingRequest request) {
        String value;
        String dataType;
        HashMap<String, String> errors = new HashMap<String, String>();
        String name = request.getName();
        if (EzyStrings.isBlank((String)name)) {
            errors.put("name", "required");
        }
        if (EzyStrings.isBlank((String)(dataType = request.getDataType()))) {
            errors.put("dataType", "required");
        }
        if (EzyStrings.isBlank((String)(value = request.getValue()))) {
            errors.put("value", "required");
        } else if (this.isInvalidSettingValue(dataType, value)) {
            errors.put("value", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateAdminUrlRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String adminUrl = request.getAdminUrl();
        if (EzyStrings.isBlank((String)adminUrl)) {
            errors.put("adminUrl", "required");
        } else if (!DefaultValidator.isValidHttpUrl((String)adminUrl)) {
            errors.put("adminUrl", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateWebUrlsRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String webUrl = request.getWebUrl();
        if (EzyStrings.isBlank((String)webUrl)) {
            errors.put("webUrl", "required");
        } else if (!DefaultValidator.isValidHttpUrl((String)webUrl)) {
            errors.put("webUrl", "invalid");
        }
        String webManagementUrl = request.getWebManagementUrl();
        if (EzyStrings.isBlank((String)webManagementUrl)) {
            errors.put("webManagementUrl", "required");
        } else if (!DefaultValidator.isValidHttpUrl((String)webUrl)) {
            errors.put("webManagementUrl", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateWebsocketUrlRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String websocketUrl = request.getWebsocketUrl();
        if (EzyStrings.isBlank((String)websocketUrl)) {
            errors.put("websocketUrl", "required");
        } else if (!DefaultValidator.isValidWebsocketUrl((String)websocketUrl)) {
            errors.put("websocketUrl", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdatePropertiesRequest request, boolean allowsEmpty) {
        HashMap<String, String> errors = new HashMap<String, String>();
        Map<String, String> properties = request.getProperties();
        if (!allowsEmpty && properties.isEmpty()) {
            errors.put("properties", "required");
        }
        for (String propertyName : properties.keySet()) {
            if (propertyName.matches("[\\d\\w_\\-\\.\\+\\$]+")) continue;
            errors.put("properties", "invalid");
            break;
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(ChangeEncryptionKeyRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String newEncryptionKey = request.getNewEncryptionKey();
        if (EzyStrings.isBlank((String)newEncryptionKey)) {
            errors.put("newEncryptionKey", "required");
        } else if (!newEncryptionKey.matches("[a-zA-Z0-9]{32}")) {
            errors.put("newEncryptionKey", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SettingsEncryptionRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getEncryptionClearText())) {
            errors.put("encryptionClearText", "required");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SettingsDecryptionRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getDecryptionEncryptedText())) {
            errors.put("decryptionEncryptedText", "required");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(Map<String, WebLanguageModel> languageModelMap, AddWebLanguageRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validate("add", errors, request.getAddWebLanguageName(), request.getAddWebLanguageFlag());
        String code = request.getAddWebLanguageCode();
        if (EzyStrings.isBlank((String)code)) {
            errors.put("addWebLanguageCode", "required");
        } else if (code.length() > 25) {
            errors.put("addWebLanguageCode", "invalid");
        } else if (languageModelMap.containsKey(code)) {
            errors.put("addWebLanguageCode", "duplicated");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(Map<String, WebLanguageModel> languageModelMap, String languageCode, UpdateWebLanguageRequest request) {
        if (!languageModelMap.containsKey(languageCode)) {
            throw new HttpNotFoundException(Collections.singletonMap("webLanguage", "notFound"));
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validate("edit", errors, request.getEditWebLanguageName(), request.getEditWebLanguageFlag());
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    private void validate(String action, Map<String, String> errors, String name, String flag) {
        if (EzyStrings.isBlank((String)name)) {
            errors.put(action + "WebLanguageName", "required");
        } else if (name.length() > 50) {
            errors.put(action + "WebLanguageName", "invalid");
        }
        if (EzyStrings.isBlank((String)flag)) {
            errors.put(action + "WebLanguageFlag", "required");
        } else if (flag.length() > 30) {
            errors.put(action + "WebLanguageFlag", "invalid");
        }
    }

    public void validate(ChangeAccessTokenEncryptionKeyRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String encryptionKey = request.getNewEncryptionKey();
        if (EzyStrings.isBlank((String)encryptionKey)) {
            errors.put("newEncryptionKey", "required");
        } else {
            try {
                byte[] encryptionKeyBytes = EzyBase64.decode((String)encryptionKey);
                if (encryptionKeyBytes.length != 32) {
                    errors.put("newEncryptionKey", "invalid");
                }
            }
            catch (Exception e) {
                errors.put("newEncryptionKey", "invalid");
            }
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SaveSocketConfigurationRequest request) {
        if (request == null) {
            return;
        }
        String configuration = request.getConfiguration();
        try {
            if (EzyStrings.isNotBlank((String)configuration)) {
                this.objectMapper.readTree(configuration);
            }
        }
        catch (IOException e) {
            throw new HttpBadRequestException(Collections.singletonMap("configuration", "invalid"));
        }
    }

    public void validate(SaveAccessTokenExpirationTimeRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        long tokenExpiredTimeInDay = request.getTokenExpiredTimeInDay();
        if (tokenExpiredTimeInDay == 0L) {
            errors.put("tokenExpiredTimeInDay", "required");
        } else if (tokenExpiredTimeInDay < 0L) {
            errors.put("tokenExpiredTimeInDay", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    private boolean isInvalidSettingValue(String dataType, String value) {
        Function<String, Boolean> validator = this.settingValueValidators.get(dataType);
        boolean valid = validator != null ? validator.apply(value) : true;
        return !valid;
    }
}

