/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.security;

import com.tvd12.ezyfox.file.EzyFileReader;
import com.tvd12.ezyfox.file.EzyFileWriter;
import com.tvd12.ezyfox.security.EzyAsyCrypt;
import java.io.File;

public class EzyFileAsyCrypt
extends EzyAsyCrypt {
    protected File outEncryptedFile;
    protected File outDecryptedFile;
    protected EzyFileWriter fileWriter;
    protected EzyFileReader fileReader;

    protected EzyFileAsyCrypt(Builder builder) {
        super(builder);
        this.fileReader = builder.fileReader;
        this.fileWriter = builder.fileWriter;
        this.outDecryptedFile = builder.outDecryptedFile;
        this.outEncryptedFile = builder.outEncryptedFile;
    }

    @Override
    public byte[] encrypt(byte[] data) throws Exception {
        byte[] bytes = super.encrypt(data);
        this.writeToFile(this.outEncryptedFile, bytes);
        return bytes;
    }

    public byte[] encrypt(File file) throws Exception {
        return this.encrypt(this.readFile(file));
    }

    public <T> T encrypt(File file, Class<T> outType) throws Exception {
        byte[] bytes = this.encrypt(file);
        return this.convertBytes(bytes, outType);
    }

    @Override
    public byte[] decrypt(byte[] data) throws Exception {
        byte[] bytes = super.decrypt(data);
        this.writeToFile(this.outDecryptedFile, bytes);
        return bytes;
    }

    public byte[] decrypt(File file) throws Exception {
        return this.decrypt(this.readFile(file));
    }

    public <T> T decrypt(File file, Class<T> outType) throws Exception {
        byte[] bytes = this.decrypt(file);
        return this.convertBytes(bytes, outType);
    }

    protected byte[] readFile(File file) {
        return this.fileReader.readBytes(file);
    }

    protected void writeToFile(File file, byte[] data) {
        if (file != null) {
            this.fileWriter.write(file, data);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EzyAsyCrypt.Builder<Builder> {
        protected File publicKeyFile;
        protected File privateKeyFile;
        protected File outEncryptedFile;
        protected File outDecryptedFile;
        protected EzyFileWriter fileWriter;
        protected EzyFileReader fileReader;

        public Builder publicKeyFile(File publicKeyFile) {
            this.publicKeyFile = publicKeyFile;
            return this;
        }

        public Builder privateKeyFile(File privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
            return this;
        }

        public Builder outEncryptedFile(File outEncryptedFile) {
            this.outEncryptedFile = outEncryptedFile;
            return this;
        }

        public Builder outDecryptedFile(File outDecryptedFile) {
            this.outDecryptedFile = outDecryptedFile;
            return this;
        }

        public Builder fileWriter(EzyFileWriter fileWriter) {
            this.fileWriter = fileWriter;
            return this;
        }

        public Builder fileReader(EzyFileReader fileReader) {
            this.fileReader = fileReader;
            return this;
        }

        @Override
        public EzyFileAsyCrypt build() {
            return new EzyFileAsyCrypt(this);
        }

        @Override
        protected byte[] getPublicKey() {
            return this.publicKey != null ? this.publicKey : this.readPublicKeyFile();
        }

        @Override
        protected byte[] getPrivateKey() {
            return this.privateKey != null ? this.privateKey : this.readPrivateKeyFile();
        }

        protected byte[] readPublicKeyFile() {
            return this.fileReader.readBytes(this.publicKeyFile);
        }

        protected byte[] readPrivateKeyFile() {
            return this.fileReader.readBytes(this.privateKeyFile);
        }
    }
}

