/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.data;

import lombok.Generated;

public class BytesRange {
    private final long from;
    private final long to;

    public BytesRange(String range) {
        this(BytesRange.extractRange(range));
    }

    public BytesRange(String[] fromTo) {
        this(BytesRange.toBytesOrThrow(fromTo[0]), fromTo.length == 1 ? 0L : BytesRange.toBytesOrThrow(fromTo[1]));
    }

    public static long toBytesOrThrow(String value) {
        long answer;
        try {
            answer = Long.parseLong(value.trim());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        if (answer < 0L) {
            throw new IllegalArgumentException("byte range can not accept nagative (" + answer + ") value");
        }
        return answer;
    }

    private static String[] extractRange(String range) {
        int dashIndex;
        int splitIndex = range.indexOf(61);
        if (splitIndex < 0) {
            splitIndex = range.indexOf(58);
        }
        String actualRange = range;
        if (splitIndex >= 0) {
            actualRange = range.substring(splitIndex + 1).trim();
        }
        if ((dashIndex = actualRange.lastIndexOf(45)) <= 0) {
            return new String[]{actualRange};
        }
        if (dashIndex >= actualRange.length() - 1) {
            return new String[]{actualRange.substring(0, dashIndex)};
        }
        return new String[]{actualRange.substring(0, dashIndex).trim(), actualRange.substring(dashIndex + 1).trim()};
    }

    @Generated
    public long getFrom() {
        return this.from;
    }

    @Generated
    public long getTo() {
        return this.to;
    }

    @Generated
    public BytesRange(long from, long to) {
        this.from = from;
        this.to = to;
    }
}

