/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.util;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.handler.IRequestController;

public final class ControllerAnnotations {
    private ControllerAnnotations() {
    }

    public static String getURI(Object controller) {
        Class<?> controllerClass = controller.getClass();
        Controller annotation = controllerClass.getAnnotation(Controller.class);
        if (annotation != null) {
            return ControllerAnnotations.getURI(controllerClass);
        }
        String uri = controller instanceof IRequestController ? ((IRequestController)controller).getDefaultUri() : "/";
        return ControllerAnnotations.correctURI(uri);
    }

    public static String getURI(Class<?> controllerClass) {
        Controller annotation = controllerClass.getAnnotation(Controller.class);
        String uri = ControllerAnnotations.getURI(annotation);
        return ControllerAnnotations.correctURI(uri);
    }

    public static String getURI(Controller annotation) {
        if (annotation == null) {
            return "/";
        }
        String uri = annotation.value();
        if (EzyStrings.isNoContent((String)uri)) {
            uri = annotation.uri();
        }
        if (EzyStrings.isNoContent((String)uri)) {
            uri = "/";
        }
        return uri;
    }

    private static String correctURI(String uri) {
        String correctUri = uri;
        if (!uri.startsWith("/")) {
            correctUri = "/" + uri;
        }
        return correctUri;
    }
}

