/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.naming;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.naming.EzyNameTranslator;
import com.tvd12.ezyfox.naming.EzyNamingCase;
import lombok.Generated;

public class EzySimpleNameTranslator
implements EzyNameTranslator {
    protected final EzyNamingCase namingCase;
    protected final String ignoredSuffix;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String translate(String originalName) {
        String startName = originalName;
        if (originalName.endsWith(this.ignoredSuffix) && originalName.length() > this.ignoredSuffix.length()) {
            startName = originalName.substring(0, originalName.length() - this.ignoredSuffix.length());
        }
        if (this.namingCase == EzyNamingCase.UPPER) {
            return EzyStrings.toUpperCase(startName);
        }
        if (this.namingCase == EzyNamingCase.LOWER) {
            return EzyStrings.toLowerCase(startName);
        }
        if (this.namingCase == EzyNamingCase.CAMEL) {
            return EzyStrings.toCamelCase(originalName);
        }
        if (this.namingCase == EzyNamingCase.DOT) {
            return EzyStrings.toDotCase(startName);
        }
        if (this.namingCase == EzyNamingCase.DASH) {
            return EzyStrings.toDashCase(startName);
        }
        if (this.namingCase == EzyNamingCase.UNDERSCORE) {
            return EzyStrings.toUnderscoreCase(startName);
        }
        return startName;
    }

    @Generated
    public EzySimpleNameTranslator(EzyNamingCase namingCase, String ignoredSuffix) {
        this.namingCase = namingCase;
        this.ignoredSuffix = ignoredSuffix;
    }

    @Override
    @Generated
    public EzyNamingCase getNamingCase() {
        return this.namingCase;
    }

    public static class Builder
    implements EzyBuilder<EzySimpleNameTranslator> {
        protected EzyNamingCase namingCase = EzyNamingCase.NATURE;
        protected String ignoredSuffix = "";

        public Builder namingCase(EzyNamingCase namingCase) {
            if (namingCase != null) {
                this.namingCase = namingCase;
            }
            return this;
        }

        public Builder ignoredSuffix(String ignoredSuffix) {
            if (ignoredSuffix != null) {
                this.ignoredSuffix = ignoredSuffix;
            }
            return this;
        }

        @Override
        public EzySimpleNameTranslator build() {
            return new EzySimpleNameTranslator(this.namingCase, this.ignoredSuffix);
        }
    }
}

