/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzySets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.constant.CommonContentType;
import org.youngmonkeys.ezyplatform.service.ContentTemplateService;

public class TemplateContentTypeManager {
    private final Set<String> additionalTemplateContentTypes;
    private final ContentTemplateService contentTemplateService;

    public TemplateContentTypeManager(ContentTemplateService contentTemplateService) {
        this.contentTemplateService = contentTemplateService;
        this.additionalTemplateContentTypes = ConcurrentHashMap.newKeySet();
    }

    public void addTemplateContentType(String contentType) {
        this.additionalTemplateContentTypes.add(contentType);
    }

    public void addTemplateContentTypes(String ... contentTypes) {
        this.addTemplateContentTypes(Arrays.asList(contentTypes));
    }

    public void addTemplateContentTypes(Collection<String> contentTypes) {
        contentTypes.forEach(this::addTemplateContentType);
    }

    public Set<String> getAllTemplateContentTypes() {
        return EzySets.combine((Collection[])new Collection[]{EzyLists.newArrayList((Object[])CommonContentType.values(), Enum::toString), this.contentTemplateService.getAllTemplateContentTypes(), this.additionalTemplateContentTypes});
    }

    public List<String> getAllSortedTemplateContentTypes() {
        return this.getAllTemplateContentTypes().stream().sorted().collect(Collectors.toList());
    }
}

