/*!
 * Copyright 2022 youngmonkeys.org
 * 
 * Licensed under the ezyplatform, Version 1.0.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     https://youngmonkeys.org/licenses/ezyplatform-1.0.0.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
ezyweb.getI18nMessage=function(e,t){var n=ezyweb.messages[e]||e;return n=t?n.toLowerCase():n.substring(0,1).toUpperCase()+n.substring(1)},ezyweb.currentTimeMillis=function(){return(new Date).getTime()},ezyweb.formatTimeStamp=function(e,t){if(!e)return"";var n=t||ezyweb.defaultDateTimeFormat||"YYYY-MM-DD HH:mm:ss";return moment(e).format(n)},ezyweb.formatTimeStampDate=function(e){return ezyweb.formatTimeStamp(parseInt(e,10),ezyweb.defaultDateFormat||"YYYY-MM-DD")},ezyweb.formatTimeStampTime=function(e){return ezyweb.formatTimeStamp(parseInt(e,10),ezyweb.defaultTimeFormat||"HH:mm:ss")},ezyweb.formatTimeStampMinute=function(e){return ezyweb.formatTimeStamp(parseInt(e,10),ezyweb.defaultDateMinuteFormat||"YYYY-MM-DD HH:mm")},ezyweb.durationToString=function(e,t){var n=e,r=n/31536e3|0,a=(n%=31536e3)/2592e3|0,o=(n%=2592e3)/86400|0,i=(n%=86400)/3600|0,s=(n%=3600)/60|0,l=n%60;(r||a||o||i||s)&&t&&l<10&&(l="0"+l);var u=l+(t?"":"s");return(r||a||o||i)&&t&&s<10&&(s="0"+s),(r||a||o||i||s)&&(u=s+(t||"m:")+u),(r||a||o)&&t&&i<10&&(i="0"+i),(r||a||o||i)&&(u=i+(t||"h:")+u),(r||a)&&t&&o<10&&(o="0"+o),(r||a||o)&&(u=o+(t||"d ")+u),r&&t&&a<10&&(a="0"+a),(r||a)&&(u=a+(t||"m-")+u),r&&(u=r+(t||"y-")+u),u},ezyweb.durationToSimpleString=function(e){var t=e,n=t/31536e3|0,r=(t%=31536e3)/2592e3|0,a=(t%=2592e3)/604800|0,o=(t%=604800)/86400|0,i=(t%=86400)/3600|0,s=(t%=3600)/60|0,l=t%60,u="0s";return(n||r||a||o||i||s||l)&&(u=l+"s"),(n||r||a||o||i||s)&&(u=s+"m"+u),(n||r||a||o||i)&&(u=i+"h"+u),(n||r||a||o)&&(u=o+"d"+u),(n||r||a)&&(u=a+"w"+u),(n||r)&&(u=r+"M"+u),n&&(u=n+"y"+u),u},ezyweb.simpleDurationStringToMillis=function(e){if(!e)return 0;for(var t=0,n={ms:1,s:1e3,m:6e4,h:36e5,d:864e5,w:6048e5,M:2592e6,y:31536e6},r="",a=null,o=0;o<e.length;++o)if(e[o]>="0"&&e[o]<="9")r+=e[o],a=null;else{a=e[o],o+1<e.length&&(e[o+1]<"0"||e[o+1]>"9")&&(a+=e[o+1],++o);var i=n[a];if(!i||!r){t=-1;break}t+=parseInt(r,10)*i,r=""}return a||(t=-1),t},ezyweb.getTimeRangeValue=function(e){return(new Date).getTime()-e},ezyweb.getTimeRangeTextValue=function(e,t){var n=ezyweb.getTimeRangeValue(e),r=n>0,a=Math.abs(n)/1e3,o=a/31536e3|0,i=(a%=31536e3)/2592e3|0,s=(a%=2592e3)/86400|0,l=(a%=86400)/3600|0,u=(a%=3600)/60|0,c=a%60|0,g="1 "+ezyweb.getI18nMessage("second",!0);return o?g=1==o?o+" "+ezyweb.getI18nMessage("year",!0):o+" "+ezyweb.getI18nMessage("years",!0):i?g=1==i?i+" "+ezyweb.getI18nMessage("month",!0):i+" "+ezyweb.getI18nMessage("months",!0):s?g=1==s?s+" "+ezyweb.getI18nMessage("day",!0):s+" "+ezyweb.getI18nMessage("days",!0):l?g=1==l?l+" "+ezyweb.getI18nMessage("hour",!0):l+" "+ezyweb.getI18nMessage("hours",!0):u?g=1==u?u+" "+ezyweb.getI18nMessage("minute",!0):u+" "+ezyweb.getI18nMessage("minutes",!0):c&&(g=1==c?c+" "+ezyweb.getI18nMessage("second",!0):c+" "+ezyweb.getI18nMessage("seconds",!0)),0==t?g:g+" "+(r?ezyweb.getI18nMessage("ago",!0):ezyweb.getI18nMessage("more",!0))},ezyweb.formatTotalResults=function(e,t){var n=t||ezyweb.paginationCountLimit||1e6,r=ezyweb.formatNumberWithCommas(e);return e>=n&&(r+="+"),r},ezyweb.formatNumberWithCommas=function(e){var t=(e=(""+e).replace(/,/g,"")).split("."),n=t[0],r=t.length>1?"."+t[1]:"";return(n=n.replace(/\B(?=(\d{3})+(?!\d))/g,","))+r},ezyweb.listToBooleanMap=function(e){var t={};return e.forEach((e=>{t[e]=!0})),t},ezyweb.removeItemFromList=function(e,t){var n=e.indexOf(t);n>-1&&e.splice(n,1)},ezyweb.moduleContainerFolders={"admin-plugin":"plugins","socket-plugin":"plugins","socket-app":"apps","web-plugin":"plugins",theme:"themes"},ezyweb.moduleTypeShortNames={"admin-plugin":"Plugin","socket-plugin":"Plugin","socket-app":"App","web-plugin":"Plugin",theme:"Theme"},ezyweb.moduleTypeNames={"admin-plugin":"Admin Plugin","socket-plugin":"Socket Plugin","socket-app":"Socket Application","web-plugin":"Web Plugin",theme:"Theme"},ezyweb.getModuleTypeShortName=function(e){return ezyweb.moduleTypeShortNames[e]||ezyweb.toCapitalizeString(e)},ezyweb.getModuleTypeName=function(e){return ezyweb.moduleTypeNames[e]||ezyweb.toCapitalizeString(e)},ezyweb.getModuleTypeNames=function(e){var t=[];return e.forEach((e=>{t.push(ezyweb.getModuleTypeName(e))})),t.join(", ")},ezyweb.errorMessageByCode={required:ezyweb.getI18nMessage("required"),invalid:ezyweb.getI18nMessage("invalid"),notFound:ezyweb.getI18nMessage("not_found"),tooShort:ezyweb.getI18nMessage("too_short"),tooLong:ezyweb.getI18nMessage("too_long"),overLength:ezyweb.getI18nMessage("over_length"),duplicated:ezyweb.getI18nMessage("duplicated"),incorrect:ezyweb.getI18nMessage("incorrect"),mismatch:ezyweb.getI18nMessage("mismatch"),tooMany:ezyweb.getI18nMessage("too_many"),rejected:ezyweb.getI18nMessage("rejected")},ezyweb.getErrorMessageByCode=function(e){return ezyweb.errorMessageByCode[e]||ezyweb.getI18nMessage("invalid")},ezyweb.textColorByStatus={ACTIVATED:"text-success",ARCHIVED:"text-info",APPROVED:"text-success",APPROVING:"text-primary",BLOCKING:"text-primary",BLOCKED:"text-danger",BURNED:"text-secondary",CLOSED:"text-danger",DELETED:"text-danger",INACTIVATED:"text-secondary",MINTED:"text-info",OPENED:"text-success",PUBLISHED:"text-success",REGISTER_OPENED:"text-success",REGISTER_CLOSED:"text-danger",REJECTED:"text-danger",REVIEWING:"text-primary",RELEASABLE:"text-info",RELEASED:"text-success"},ezyweb.getTextColorByStatus=function(e){return ezyweb.textColorByStatus[e]||""},ezyweb.toDisplayString=function(e){if(!e)return"";var t=e.replaceAll("."," ").replaceAll("-"," ").replaceAll("_"," ").replaceAll("  "," ");return t.length<=1?t:t[0].toUpperCase()+t.substring(1)},ezyweb.toCapitalizeString=function(e){ezyweb.toDisplayString(e);for(var t=e.split(" "),n=0;n<t.length;n++)t[n]=t[n].charAt(0).toUpperCase()+t[n].slice(1);return t.join(" ")},ezyweb.truncateString=function(e,t,n){if(!e)return"";if(e.length<=t)return e;var r=e.substring(0,t);return n&&(r+=" "+n),r},ezyweb.getHtmlBodyContent=function(e){if(!e)return"";var t="<body>",n=e.indexOf(t),r=e.indexOf("</body>");return n>=0&&r>0?e.substring(n+t.length(),r):e},ezyweb.removeHtmlTagAndSub=function(e,t,n){if(!e)return"";for(var r="",a=!1,o=!1,i=0;i<e.length;++i)if("<"==e[i]&&(o=!0),o)">"==e[i]&&(o=!1),r.length>1&&" "!=r[r.length-1]&&(r+=" ");else if("\t"==e[i]||"\n"==e[i]||" "==e[i]?(r.length>1&&" "!=r[r.length-1]&&(r+=" "),a=!0):(r+=e[i],a=!1),r.length>=t&&a)break;return r+(0!=n?" ...":"")},ezyweb.normalCharacters="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",ezyweb.randomString=function(e){for(var t="",n=ezyweb.normalCharacters,r=n.length,a=0;a<e;a++)t+=n.charAt(Math.floor(Math.random()*r));return t},ezyweb.getCurrentUrlParameter=function(e){return new URL(document.location).searchParams.get(e)},ezyweb.joinToString=function(e,t,n){for(var r="",a=0;a<e.length;++a)r+=n?n(e[a]):e[a],a<e.length-1&&(r+=t);return r},ezyweb.mergeObjects=function(e){var t={};return e.forEach((e=>{Object.entries(e).forEach((([e,n])=>{t[e]=n}))})),t},ezyweb.mergeObjectsToFirst=function(e){for(var t=e[0],n=1;n<e.length;++n)Object.entries(e[n]).forEach((([e,n])=>{t[e]=n}))},ezyweb.deepMergeObjects=function(e,...t){if("object"!=typeof e||null===e)return e;var n=[];for(var r of t)"object"==typeof r&&null!==r&&n.push({target:e,source:r});for(;n.length;){var{target:a,source:o}=n.pop();for(const e in o){if(!Object.prototype.hasOwnProperty.call(o,e))continue;const t=o[e],r=a[e];"object"!=typeof r||"object"!=typeof t||null===r||null===t||Array.isArray(r)||Array.isArray(t)?a[e]=t:n.push({target:r,source:t})}}return e},ezyweb.fetchAll=function(e,t){var n=0,r=e=>!e.condition||e.condition();if(e.forEach((e=>{r(e)&&++n})),n){var a=0,o=()=>{++a==n&&t()};e.forEach((e=>{r(e)&&e(o)}))}else t()},ezyweb.extractIframeSrcIfNeed=function(e){var t=e;if(e.indexOf("<iframe")>=0){var n=e.match(/src="([^"]+)"/);n&&n[1]&&(t=n[1])}return t},ezyweb.flattenObject=function(e,t="",n={}){for(var r in e)if(e.hasOwnProperty(r)){var a=t?`${t}.${r}`:r;"object"==typeof e[r]&&null!==e[r]?ezyweb.flattenObject(e[r],a,n):n[a]=e[r]}return n},ezyweb.copyToClipboard=function(e,t,n){var r=$("#"+e),a=t?r.val():r.text();navigator.clipboard.writeText(a.trim()),shortToast&&shortToast(ezyweb.messages.clipboard,n+" "+ezyweb.messages.copied.toLowerCase())},ezyweb.formViewByFormData=new WeakMap,ezyweb.formDataToObject=function(e){var t={};new FormData(document.querySelector(`#${e}`)).forEach(((e,n)=>{Reflect.has(t,n)?(Array.isArray(t[n])||(t[n]=[t[n]]),t[n].push(e)):t[n]=e}));var n={};return ezyweb.formViewByFormData.set(t,n),Object.keys(t).forEach((t=>{var r=$(`#${e} [name="${t}"]`).attr("id")||t;n[r]=t})),t},ezyweb.setInputLengthText=function(e){var t=$("#"+e),n=t?t.val():"";n=n||"",$("#"+e+"Length").text(n.length)},ezyweb.watchInputKeyDown=function(e,t,n){var r=$("#"+e);r.keydown((function(){var e=$(this).val();"Enter"===event.key?n&&n():e.length>t&&$(r).val(e.substring(0,e.length-1))})),r.keyup((function(){$("#"+e+"Length").text(r.val().length>t?t:r.val().length)}))},ezyweb.formatInputNumber=function(e){$(e).val(ezyweb.formatNumberWithCommas($(e).val()))},ezyweb.extractMediaUrl=function(e){return e?(e.url||"").trim()||"/api/v1/media/"+e.name:""},ezyweb.scrollToElement=function(e,t){var n=e.startsWith("#")?e:"#"+e;if(t){var r=$(n);if(r){var a=r.offset();a&&$("html, body").animate({scrollTop:a.top},t)}}else document.querySelector(n).scrollIntoView()},ezyweb.syntaxHighlightJson=function(e){return"string"!=typeof e&&(e=JSON.stringify(e,void 0,2)),(e=e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")).replace(/('(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\'])*'(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,(function(e){var t="number";return/^'/.test(e)?t=/:$/.test(e)?"key":"string":/true|false/.test(e)?t="boolean":/null/.test(e)&&(t="null"),'<span class="'+t+'">'+e+"</span>"}))};var KB_SIZE=1024,MB_SIZE=1024*KB_SIZE,GB_SIZE=1024*MB_SIZE,TB_SIZE=1024*GB_SIZE;ezyweb.toCapacityString=function(e){return e/TB_SIZE|0?(e/TB_SIZE*10|0)/10+"TB":e/GB_SIZE|0?(e/GB_SIZE*10|0)/10+"GB":e/MB_SIZE|0?(e/MB_SIZE*10|0)/10+"MB":e/KB_SIZE|0?(e/KB_SIZE*10|0)/10+"KB":e+"B"};var THOUSAND=1e3,MILLION=1e3*THOUSAND,BILLION=1e3*MILLION,TRILLION=1e3*BILLION;ezyweb.toCountString=function(e){return e/TRILLION|0?(e/TRILLION*10|0)/10+"T":e/BILLION|0?(e/BILLION*10|0)/10+"B":e/MILLION|0?(e/MILLION*10|0)/10+"M":e/THOUSAND|0?(e/THOUSAND*10|0)/10+"K":e},ezyweb.setCookie=function(e,t,n){var r="";if(n){var a=new Date;a.setTime(a.getTime()+24*n*60*60*1e3),r="; expires="+a.toUTCString()}document.cookie=e+"="+t+r+"; path=/"},ezyweb.deleteCookie=function(e){document.cookie=e+"=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;"},ezyweb.getCookie=function(e){for(var t=document.cookie.split("; "),n=0;n<t.length;++n){var r=t[n].indexOf("="),a=[t[n].substring(0,r).trim(),t[n].substring(r+1).trim()];if(a[0]==e&&a[1])return a[1]}return""},ezyweb.getCookieAccessToken=function(){return ezyweb.getCookie("accessToken")},ezyweb.getCookieSocketAccessToken=function(){return ezyweb.getCookie("socketAccessToken")},ezyweb.showLoadingScreen=function(e){ezyweb.loadingScreenShowing||(ezyweb.loadingScreenShowing=!0,(e||{}).showPercent?$("#ezyLoadingScreenPercent").text("0%").removeClass("d-none"):$("#ezyLoadingScreenPercent").addClass("d-none"),$("#loadingScreen").removeClass("d-none"))},ezyweb.setLoadingScreenPercent=function(e){$("#ezyLoadingScreenPercent").text(`${e}%`)},ezyweb.hideLoadingScreen=function(){ezyweb.loadingScreenShowing&&(ezyweb.loadingScreenShowing=!1,$("#loadingScreen").addClass("d-none"))},ezyweb.logout=function(){var e=document.createElement("form");e.method="POST",e.action="/logout"+(ezyweb.lang?"?lang="+ezyweb.lang:""),document.body.appendChild(e),e.submit()},ezyweb.redirectToLogin=function(){document.cookie="accessToken=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;",window.location="/login"+(ezyweb.lang?"?lang="+ezyweb.lang:"")},ezyweb.redirectToNotFound=function(){window.location="/not-found"+(ezyweb.lang?"?lang="+ezyweb.lang:"")},ezyweb.redirectToServerError=function(){window.location="/server-error"+(ezyweb.lang?"?lang="+ezyweb.lang:"")},ezyweb.processGetApiErrors=function(e,t){ezyweb.processUpdateApiErrors({},e,t)},ezyweb.processUpdateApiErrors=function(e,t,n){if(t)if(401!=t.status){if((404!=t.status||n&&n[404])&&(403!=t.status||n&&n[403])&&(500!=t.status||n&&n[500])){var r=t.responseJSON||{},a=ezyweb.formViewByFormData.get(e);for(var o in a&&Object.entries(a).forEach((([e,t])=>{r[e]=r[t]})),r)r[o]||delete r[o];Object.keys(r).forEach((e=>{var t=r[e],n=$("#"+e+"Error");n.length&&n.text(ezyweb.getErrorMessageByCode(t));var a=$("#"+e+"ErrorLabel");a.length&&a.removeClass("d-none")})),a=a||e,Object.keys(a).forEach((e=>{if(!r[e]){var t=$("#"+e+"ErrorLabel");t.length&&t.addClass("d-none")}})),n&&(n.postHandle?n.postHandle(t):n(t))}}else ezyweb.redirectToLogin();else shortToast&&shortToast(ezyweb.messages.warning,ezyweb.messages.check_your_internet_connection)},ezyweb.hideFormErrors=function(e){var t=ezyweb.formViewByFormData.get(e)||e;Object.keys(t).forEach((e=>{var t=$("#"+e+"ErrorLabel");t.length&&t.addClass("d-none")}))},ezyweb.resetFormData=function(e,t){var n=ezyweb.formViewByFormData.get(e)||e;ezyweb.hideFormErrors(n),Object.keys(n).forEach((e=>{var n=$("#"+e);t?n.val(""):n.is("select")||n.val("")}))},ezyweb.getUploadFileApiErrorMessage=function(e){var t,n=e.responseJSON||{};return 403==e.status?t=ezyweb.messages.permission_denied:400==e.status?n.fileType?t=ezyweb.messages.invalid_file_type:n.uploadSize?t=ezyweb.messages.file_too_big:(n.fileName||n.fileExtension)&&(t=ezyweb.messages.invalid_upload_file):t=ezyweb.messages.server_error,t},ezyweb.processUploadFileApiErrors=function(e,t){if(401!=e.status){var n=ezyweb.getUploadFileApiErrorMessage(e);if(n){var r=t.name+"File";$("#"+r).val(""),$("#"+r+"Label").text(t.chooseFileLabelText),$("#"+r+"Error").text(n),$("#"+r+"ErrorLabel").removeClass("d-none")}}else ezyweb.redirectToLogin()},ezyweb.formatDateStringElements=function(){$(".date-string").each(((e,t)=>{var n=$(t).text();isNaN(n)||$(t).text(ezyweb.formatTimeStampDate(parseInt(n,10)))}))},ezyweb.formatTimeStringElements=function(){$(".time-string").each(((e,t)=>{var n=$(t).text();isNaN(n)||$(t).text(ezyweb.formatTimeStampTime(parseInt(n,10)))}))},ezyweb.formatDateTimeStringElements=function(){$(".date-time-string").each(((e,t)=>{var n=$(t).text();isNaN(n)||$(t).text(ezyweb.formatTimeStamp(parseInt(n,10)))}))},ezyweb.formatDateTimeMinuteStringElements=function(){$(".date-time-minute-string").each(((e,t)=>{var n=$(t).text();isNaN(n)||$(t).text(ezyweb.formatTimeStampMinute(parseInt(n,10)))}))},ezyweb.formatStatusTextElements=function(){$(".status-text").each(((e,t)=>{$(t).addClass(ezyweb.getTextColorByStatus($(t).attr("status")))}))},ezyweb.formatNumberWithCommasElements=function(){$(".commas-number-string").each(((e,t)=>{var n=$(t).text();n&&(n=n.trim(),isNaN(n)||$(t).text(ezyweb.formatNumberWithCommas(n)))}))},ezyweb.createDataTable=function(e,t,n){return $("#"+e).DataTable({paging:!0,lengthChange:!1,searching:0!=n,ordering:!0,info:!0,autoWidth:!1,responsive:!0,pageLength:t||5,drawCallback:function(e){ezyweb.formatDateStringElements(),ezyweb.formatDateTimeStringElements(),ezyweb.formatStatusTextElements()}})},ezyweb.appendLangParameterToUrl=function(e){return ezyweb.lang?e.includes("?")?e+"&lang="+ezyweb.lang:e+"?lang="+ezyweb.lang:e},ezyweb.appendLangParameterToFormActions=function(){ezyweb.lang&&$("form").each(((e,t)=>{var n=$(t).attr("action");if(n&&n.startsWith("/")){var r=n.includes("?")?n+"&lang="+ezyweb.lang:n+"?lang="+ezyweb.lang;$(t).attr("action",r)}}))},ezyweb.appendLangParameterToLinks=function(e){var t=e||ezyweb.lang;$("a").each(((e,n)=>{var r=$(n).attr("href");if(r&&r.startsWith("/")&&r.indexOf("lang=")<0){var a=r.includes("?")?r+"&lang="+t:r+"?lang="+t;$(n).attr("href",a)}}))},ezyweb.wrapTextIfNeed=function(e,t,n){return n?"<"+t+">"+e+"</"+t+">":e},ezyweb.onLanguageSelected=function(e){var t=window.location,n="";if(t.search)for(var r=t.search.substring(1).split("&"),a=0;a<r.length;a++){"lang"!=r[a].split("=")[0]&&(n+=(n?"&":"?")+r[a])}e!=ezyweb.defaultLang&&(n+=(n?"&":"?")+"lang="+e),ezyweb.setCookie("lang",e),window.location=t.pathname+n},ezyweb.onCsvFileChanged=function(e,t,n){var r=e.files[0];if(r){var a=new FileReader;a.onload=function(e){var n=e.target.result,a=ezyweb.parseCsvContent(n);t(r,a)},a.readAsText(r)}},ezyweb.parseCsvContent=function(e,t){var n=e.split("\n"),r=[];if(n.length){var a=n[0].indexOf(",")>=0?",":";";t||(n=n.slice(1)),n.forEach((e=>{r.push(ezyweb.readCsvLine(e,a))}))}return r},ezyweb.readCsvLine=function(e,t){for(var n=[],r="",a=e.split(t),o=0;o<a.length;++o){var i=a[o].trim();r.startsWith('"')?i.endsWith('"')?(r=(r+=a[o].slice(0,a[o].lastIndexOf('"')+1)).slice(1,r.length-1),n.push(r.trim()),r=""):r+=a[o]+t:i.startsWith('"')?r=a[o].slice(a[o].indexOf('"')):(n.push(i),r="")}return n};