/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.util.PropertiesUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

public interface FileSystemManager {
    public static final String FOLDER_UPLOAD = "upload";
    public static final String FOLDER_RUNTIME = ".runtime";
    public static final String FOLDER_SETTINGS = "settings";
    public static final String FILE_CONFIG_PROPERTIES = "config.properties";
    public static final String FILE_MODULE_PROPERTIES = "module.properties";
    public static final String FILE_ENCRYPTION_KEYS = "encryption-keys.txt";

    public String getEzyHomePathString();

    default public File getEzyHomePath() {
        return new File(EzyStrings.isBlank((String)this.getEzyHomePathString()) ? "." : this.getEzyHomePathString());
    }

    public static File concatWithEzyHome(String ezyplatformHome, String childPath) {
        return (EzyStrings.isBlank((String)ezyplatformHome) ? Paths.get(childPath, new String[0]) : Paths.get(ezyplatformHome, childPath)).toFile();
    }

    default public String concatWithEzyHome(String path) {
        return FileSystemManager.concatWithEzyHome(this.getEzyHomePathString(), path).toString();
    }

    default public File concatWithEzyHome(Path path) {
        return new File(this.concatWithEzyHome(path.toString()));
    }

    default public File getUploadFolder() {
        return new File(this.concatWithEzyHome(FOLDER_UPLOAD));
    }

    default public File getMediaFilePath(MediaType mediaType, String fileName) {
        return this.getMediaFilePath(mediaType.getFolder(), fileName);
    }

    default public File getMediaFilePath(String containerFolder, String fileName) {
        return Paths.get(this.getMediaFolderPath(containerFolder).toString(), fileName).toFile();
    }

    default public File getMediaFolderPath(MediaType mediaType) {
        return this.getMediaFolderPath(mediaType.getFolder());
    }

    default public File getMediaFolderPath(String containerFolder) {
        return Paths.get(this.getUploadFolder().toString(), containerFolder).toFile();
    }

    public static String readConfigAndGetEzyHomePathString() {
        Properties configProperties = new BaseFileReader().read(FILE_CONFIG_PROPERTIES);
        PropertiesUtil.setVariableValues((Map)configProperties);
        return configProperties.getProperty("ezyplatform.home");
    }

    public static List<File> getModuleFolders(String ezyplatformHome, String containerFolder) {
        return EzyLists.filter(FolderProxy.listFolders(FileSystemManager.concatWithEzyHome(ezyplatformHome, containerFolder)), it -> Files.exists(Paths.get(it.toString(), FILE_MODULE_PROPERTIES), new LinkOption[0]));
    }
}

