/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tvd12.ezyfox.io.EzyStrings;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.util.Strings;

public class MediaModel {
    private long id;
    private String name;
    private String url;
    private String originalName;
    private String uploadFrom;
    private MediaType type;
    private String typeText;
    private String mimeType;
    private long ownerUserId;
    private long ownerAdminId;
    private String title;
    private String caption;
    private String alternativeText;
    private String description;
    private long fileSize;
    private boolean publicMedia;
    private String status;
    private long createdAt;
    private long updatedAt;

    public String getTypeText() {
        return EzyStrings.isBlank((String)this.typeText) ? Strings.from((Object)this.type) : this.typeText;
    }

    public static String getMediaUrlOrNull(MediaModel media) {
        return MediaModel.getMediaUrlOrDefault(media, CommonConstants.NULL_STRING);
    }

    public static String getMediaUrlOrDefault(MediaModel media, String defaultUrl) {
        return media == null ? defaultUrl : media.getUrlOrDefault(defaultUrl);
    }

    public static String toMediaUrlOrDefault(String mediaName, String mediaUrl, String defaultUrl) {
        return EzyStrings.isBlank((String)mediaUrl) ? (EzyStrings.isBlank((String)mediaName) ? defaultUrl : "/api/v1/media/" + mediaName) : mediaUrl;
    }

    public static String toMeMediaUrlOrDefault(String mediaName, String mediaUrl, String defaultUrl) {
        return EzyStrings.isBlank((String)mediaUrl) ? (EzyStrings.isBlank((String)mediaName) ? defaultUrl : "/api/v1/me/media/" + mediaName) : mediaUrl;
    }

    @JsonIgnore
    public String getUrlOrNull() {
        return this.getUrlOrDefault(CommonConstants.NULL_STRING);
    }

    public String getUrlOrDefault(String defaultUrl) {
        return MediaModel.toMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    public String getMeUrlOrDefault(String defaultUrl) {
        return MediaModel.toMeMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    public String getOriginalName() {
        return EzyStrings.isBlank((String)this.originalName) ? this.name : this.originalName;
    }

    @Generated
    MediaModel(long id, String name, String url, String originalName, String uploadFrom, MediaType type, String typeText, String mimeType, long ownerUserId, long ownerAdminId, String title, String caption, String alternativeText, String description, long fileSize, boolean publicMedia, String status, long createdAt, long updatedAt) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.originalName = originalName;
        this.uploadFrom = uploadFrom;
        this.type = type;
        this.typeText = typeText;
        this.mimeType = mimeType;
        this.ownerUserId = ownerUserId;
        this.ownerAdminId = ownerAdminId;
        this.title = title;
        this.caption = caption;
        this.alternativeText = alternativeText;
        this.description = description;
        this.fileSize = fileSize;
        this.publicMedia = publicMedia;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Generated
    public static MediaModelBuilder builder() {
        return new MediaModelBuilder();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUploadFrom() {
        return this.uploadFrom;
    }

    @Generated
    public MediaType getType() {
        return this.type;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public long getOwnerUserId() {
        return this.ownerUserId;
    }

    @Generated
    public long getOwnerAdminId() {
        return this.ownerAdminId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getAlternativeText() {
        return this.alternativeText;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public long getFileSize() {
        return this.fileSize;
    }

    @Generated
    public boolean isPublicMedia() {
        return this.publicMedia;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public static class MediaModelBuilder {
        @Generated
        private long id;
        @Generated
        private String name;
        @Generated
        private String url;
        @Generated
        private String originalName;
        @Generated
        private String uploadFrom;
        @Generated
        private MediaType type;
        @Generated
        private String typeText;
        @Generated
        private String mimeType;
        @Generated
        private long ownerUserId;
        @Generated
        private long ownerAdminId;
        @Generated
        private String title;
        @Generated
        private String caption;
        @Generated
        private String alternativeText;
        @Generated
        private String description;
        @Generated
        private long fileSize;
        @Generated
        private boolean publicMedia;
        @Generated
        private String status;
        @Generated
        private long createdAt;
        @Generated
        private long updatedAt;

        @Generated
        MediaModelBuilder() {
        }

        @Generated
        public MediaModelBuilder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public MediaModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MediaModelBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public MediaModelBuilder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        @Generated
        public MediaModelBuilder uploadFrom(String uploadFrom) {
            this.uploadFrom = uploadFrom;
            return this;
        }

        @Generated
        public MediaModelBuilder type(MediaType type) {
            this.type = type;
            return this;
        }

        @Generated
        public MediaModelBuilder typeText(String typeText) {
            this.typeText = typeText;
            return this;
        }

        @Generated
        public MediaModelBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Generated
        public MediaModelBuilder ownerUserId(long ownerUserId) {
            this.ownerUserId = ownerUserId;
            return this;
        }

        @Generated
        public MediaModelBuilder ownerAdminId(long ownerAdminId) {
            this.ownerAdminId = ownerAdminId;
            return this;
        }

        @Generated
        public MediaModelBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public MediaModelBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Generated
        public MediaModelBuilder alternativeText(String alternativeText) {
            this.alternativeText = alternativeText;
            return this;
        }

        @Generated
        public MediaModelBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MediaModelBuilder fileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        @Generated
        public MediaModelBuilder publicMedia(boolean publicMedia) {
            this.publicMedia = publicMedia;
            return this;
        }

        @Generated
        public MediaModelBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public MediaModelBuilder createdAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public MediaModelBuilder updatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public MediaModel build() {
            return new MediaModel(this.id, this.name, this.url, this.originalName, this.uploadFrom, this.type, this.typeText, this.mimeType, this.ownerUserId, this.ownerAdminId, this.title, this.caption, this.alternativeText, this.description, this.fileSize, this.publicMedia, this.status, this.createdAt, this.updatedAt);
        }

        @Generated
        public String toString() {
            return "MediaModel.MediaModelBuilder(id=" + this.id + ", name=" + this.name + ", url=" + this.url + ", originalName=" + this.originalName + ", uploadFrom=" + this.uploadFrom + ", type=" + (Object)((Object)this.type) + ", typeText=" + this.typeText + ", mimeType=" + this.mimeType + ", ownerUserId=" + this.ownerUserId + ", ownerAdminId=" + this.ownerAdminId + ", title=" + this.title + ", caption=" + this.caption + ", alternativeText=" + this.alternativeText + ", description=" + this.description + ", fileSize=" + this.fileSize + ", publicMedia=" + this.publicMedia + ", status=" + this.status + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

