/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.reader;

import com.tvd12.properties.file.exception.YamlFileException;
import com.tvd12.properties.file.exception.YamlInvalidSyntaxException;
import com.tvd12.properties.file.reader.InputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class YamlFileReader
implements InputStreamReader {
    private static final char TAB_CHAR = '\t';
    private static final char SPACE_CHAR = ' ';
    private static final Set<Character> SPACE_CHARACTERS;
    private static final String SEPARATE_CHAR = ":";
    private static final String PROPERTY_CHAIN_CHAR = ".";
    private static final String START_COMMENT_CHAR = "#";
    private static final String KEY_PATTERN = "[a-zA-Z0-9._-]+";
    private static final String DASH_CHAR = "-";
    private static final String DOUBLE_QUOTE_CHAR = "\"";
    private static final String SINGLE_QUOTE_CHAR = "'";
    private static final String EMPTY_STRING = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readInputStream(InputStream inputStream) {
        Properties properties;
        BufferedReader reader = new BufferedReader(new java.io.InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            properties = this.read(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new YamlFileException("read yaml from input stream: " + inputStream + " error", e);
            }
        }
        reader.close();
        inputStream.close();
        return properties;
    }

    protected Properties read(BufferedReader reader) throws IOException {
        String line;
        int lineIndex = 0;
        int lastSpaceCount = 0;
        String lastParentKey = null;
        String lastPropertyKey = null;
        Properties answer = new Properties();
        TreeMap<Integer, YamlNode> nodes = new TreeMap<Integer, YamlNode>();
        while ((line = reader.readLine()) != null) {
            int spaceCount;
            ++lineIndex;
            String lineTrim = line.trim();
            if (lineTrim.isEmpty() || lineTrim.startsWith(START_COMMENT_CHAR)) continue;
            if (!lineTrim.contains(SEPARATE_CHAR)) {
                if (lastPropertyKey == null) {
                    throw new YamlInvalidSyntaxException("invalid syntax, line " + lineIndex + ": '" + line + SINGLE_QUOTE_CHAR);
                }
                String lastValue = answer.getProperty(lastPropertyKey, EMPTY_STRING);
                if (lineTrim.startsWith(DASH_CHAR)) {
                    if (lineTrim.length() > 1) {
                        String value = lineTrim.substring(1).trim();
                        lastValue = lastValue.isEmpty() ? value : lastValue + "," + value;
                    }
                } else {
                    lastValue = lastValue.isEmpty() ? lineTrim : lastValue + " " + lineTrim;
                }
                answer.put(lastPropertyKey, lastValue.trim());
                continue;
            }
            String[] keyValue = this.splitKeyValue(lineTrim);
            String keyTrim = keyValue[0].trim();
            if (keyTrim.isEmpty()) {
                throw new YamlInvalidSyntaxException("invalid syntax, missing key, line " + lineIndex + ": " + line);
            }
            String clearKey = this.getClearKey(keyTrim);
            if (clearKey == null) {
                spaceCount = this.countStartedSpace(line);
                if (lastPropertyKey == null || spaceCount <= lastSpaceCount) {
                    throw new YamlInvalidSyntaxException("invalid syntax, invalid key: '" + keyTrim + "', line " + lineIndex + ": " + line + ", key pattern is: " + KEY_PATTERN);
                }
                String lastValue = answer.getProperty(lastPropertyKey, EMPTY_STRING);
                lastValue = lastValue.isEmpty() ? lineTrim : lastValue + " " + lineTrim;
                answer.put(lastPropertyKey, lastValue.trim());
                continue;
            }
            spaceCount = this.countStartedSpace(line);
            Map.Entry parentEntry = nodes.lowerEntry(spaceCount);
            YamlNode parentNode = null;
            if (parentEntry != null) {
                parentNode = (YamlNode)parentEntry.getValue();
            }
            if (keyValue.length == 1) {
                lastParentKey = parentNode != null ? parentNode.propertyName + PROPERTY_CHAIN_CHAR + keyTrim : clearKey;
                nodes.put(spaceCount, new YamlNode(lastParentKey));
                lastPropertyKey = lastParentKey;
            } else {
                if (parentNode == null) {
                    lastParentKey = null;
                }
                String fullKey = clearKey;
                if (lastParentKey != null) {
                    fullKey = lastParentKey + PROPERTY_CHAIN_CHAR + clearKey;
                }
                answer.put(fullKey, this.getClearValue(keyValue[1]));
                lastPropertyKey = fullKey;
            }
            lastSpaceCount = spaceCount;
        }
        return answer;
    }

    private String[] splitKeyValue(String line) {
        int indexOfSeparateChar = line.indexOf(SEPARATE_CHAR);
        String key = line.substring(0, indexOfSeparateChar);
        if (indexOfSeparateChar >= line.length() - 1) {
            return new String[]{key};
        }
        String value = line.substring(indexOfSeparateChar + 1);
        return new String[]{key, value};
    }

    private String getClearKey(String rawKey) {
        String clearKey = rawKey;
        if (clearKey.startsWith(DASH_CHAR)) {
            clearKey = clearKey.substring(1).trim();
        }
        if (clearKey.isEmpty()) {
            return null;
        }
        if (!clearKey.matches(KEY_PATTERN)) {
            return null;
        }
        return clearKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getClearValue(String rawValue) {
        String clearValue = rawValue.trim();
        int commentIndex = clearValue.indexOf(START_COMMENT_CHAR);
        if (commentIndex >= 0) {
            clearValue = clearValue.substring(0, commentIndex).trim();
        }
        if (clearValue.startsWith(DOUBLE_QUOTE_CHAR) && clearValue.endsWith(DOUBLE_QUOTE_CHAR)) {
            if (clearValue.length() <= 2) return EMPTY_STRING;
            return clearValue.substring(1, clearValue.length() - 1);
        }
        if (clearValue.startsWith(SINGLE_QUOTE_CHAR) && clearValue.endsWith(SINGLE_QUOTE_CHAR)) {
            if (clearValue.length() <= 2) return EMPTY_STRING;
            return clearValue.substring(1, clearValue.length() - 1);
        }
        if (clearValue.startsWith(">-")) {
            if (clearValue.length() <= 2) return EMPTY_STRING;
            return clearValue.substring(2).trim();
        }
        if (clearValue.startsWith("|")) {
            if (clearValue.length() <= 1) return EMPTY_STRING;
            return clearValue.substring(1).trim();
        }
        if (!clearValue.startsWith(">")) return clearValue.trim();
        if (clearValue.length() <= 1) return EMPTY_STRING;
        return clearValue.substring(1).trim();
    }

    protected int countStartedSpace(String line) {
        char ch;
        int count = 0;
        int i = 0;
        while (SPACE_CHARACTERS.contains(Character.valueOf(ch = line.charAt(i)))) {
            count = ch == '\t' ? (count += 4) : ++count;
            ++i;
        }
        return count;
    }

    static {
        HashSet<Character> spaceCharacters = new HashSet<Character>();
        spaceCharacters.add(Character.valueOf('\t'));
        spaceCharacters.add(Character.valueOf(' '));
        SPACE_CHARACTERS = Collections.unmodifiableSet(spaceCharacters);
    }

    private static class YamlNode {
        private String propertyName;

        public YamlNode(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

