/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.struct;

import com.tvd12.properties.file.annotation.PropertyAnnotations;
import com.tvd12.properties.file.mapping.MappingLevel;
import com.tvd12.properties.file.struct.MethodFilter;
import com.tvd12.properties.file.struct.MethodStruct;
import com.tvd12.properties.file.util.ReflectionClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ClassStruct {
    protected final Class<?> clazz;
    protected final MappingLevel mappingLevel;
    protected final MethodFilter methodFilter;
    protected final Map<String, MethodStruct> methods;
    protected final List<MethodStruct> declaredFieldStructs;
    protected final PropertyAnnotations propertyAnnotations;

    public ClassStruct(Class<?> clazz, MappingLevel mappingLevel, PropertyAnnotations propertyAnnotations) {
        this.clazz = clazz;
        this.mappingLevel = mappingLevel;
        this.propertyAnnotations = propertyAnnotations;
        this.methods = new HashMap<String, MethodStruct>();
        this.declaredFieldStructs = new ArrayList<MethodStruct>();
        this.methodFilter = this.methodFilter();
        this.initWithFields();
        this.initWithMethods();
        this.initWithDeclaredFields();
    }

    private void initWithFields() {
        Set<Field> fields = this.getAcceptedFields();
        for (Field field : fields) {
            this.addMethod(this.initWithField(field));
        }
    }

    private void initWithMethods() {
        Set<Method> methods = this.getAcceptedMethods();
        for (Method method : methods) {
            if (!this.methodFilter.filter(method)) continue;
            this.addMethod(this.initWithMethod(method));
        }
    }

    private void initWithDeclaredFields() {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            this.declaredFieldStructs.add(this.initWithField(field));
        }
    }

    protected abstract MethodStruct initWithField(Field var1);

    protected abstract MethodStruct initWithMethod(Method var1);

    protected abstract boolean validateMethod(Method var1);

    protected boolean containsKey(String key) {
        return this.methods.containsKey(key);
    }

    protected boolean containsMethod(Method method) {
        for (MethodStruct cover : this.methods.values()) {
            if (cover.getMethod() == null || !cover.getMethod().equals(method)) continue;
            return true;
        }
        return false;
    }

    protected MethodStruct getMethodStruct(String key) {
        return this.methods.get(key);
    }

    protected void addMethod(MethodStruct method) {
        this.methods.put(method.getKey(), method);
    }

    protected Set<Field> getAcceptedFields() {
        Set<Field> fields = this.mappingLevel == MappingLevel.ALL ? ReflectionClassUtil.getValidFields(this.clazz) : ReflectionClassUtil.getFieldsWithAnnotations(this.clazz, this.propertyAnnotations.getAnnotationClasses());
        return fields;
    }

    protected Set<Method> getAcceptedMethods() {
        Set<Method> methods = this.mappingLevel == MappingLevel.ALL ? ReflectionClassUtil.getPublicMethods(this.clazz) : ReflectionClassUtil.getMethodsWithAnnotations(this.clazz, this.propertyAnnotations.getAnnotationClasses());
        return methods;
    }

    public Set<String> keySet() {
        return this.methods.keySet();
    }

    public int methodCount() {
        return this.methods.size();
    }

    protected MethodFilter methodFilter() {
        return method -> this.validateMethod(method) && !this.containsMethod(method);
    }

    public Constructor getNoArgsDeclaredConstructor() {
        return ReflectionClassUtil.getNoArgsDeclaredConstructor(this.clazz);
    }

    public Constructor<?> getMaxArgsDeclaredConstructor() {
        return ReflectionClassUtil.getMaxArgsDeclaredConstructor(this.clazz);
    }

    public Object newObjectInstance() {
        return ReflectionClassUtil.newInstance(this.clazz);
    }
}

