/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.gamebox.constant.IRoomStatus;
import com.tvd12.gamebox.constant.RoomStatus;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class Room {
    protected final long id;
    protected final String name;
    protected String password;
    protected IRoomStatus status = RoomStatus.WAITING;
    protected static final String NAME_PREFIX = "Room#";

    public Room(String name) {
        this.name = name;
        this.id = Builder.ID_GENERATOR.incrementAndGet();
    }

    protected Room(Builder<?> builder) {
        this.id = builder.id;
        this.name = builder.name;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.id == ((Room)obj).id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "(name = " + this.name + ", id = " + this.id + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public IRoomStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setStatus(IRoomStatus status) {
        this.status = status;
    }

    public static class Builder<B extends Builder<B>>
    implements EzyBuilder<Room> {
        protected Long id;
        protected String name;
        protected static final AtomicLong ID_GENERATOR = new AtomicLong(0L);

        public B id(long id) {
            this.id = id;
            return (B)this;
        }

        public B name(String name) {
            this.name = name;
            return (B)this;
        }

        public Room build() {
            if (this.id == null) {
                this.id = ID_GENERATOR.incrementAndGet();
            }
            if (this.name == null) {
                this.name = Room.NAME_PREFIX + this.id;
            }
            this.preBuild();
            return this.newProduct();
        }

        protected void preBuild() {
        }

        protected Room newProduct() {
            return new Room(this);
        }
    }
}

