/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.mapping.jaxb.EzySimpleXmlMapper;
import com.tvd12.ezyfox.mapping.jaxb.EzyXmlReader;
import com.tvd12.ezyfox.util.EzyInitable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.constant.EzyCommand;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.constant.EzyMaxRequestPerSecondAction;
import com.tvd12.ezyfoxserver.constant.SslType;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyAppsSetting;
import com.tvd12.ezyfoxserver.setting.EzyEventControllerSettingBuilder;
import com.tvd12.ezyfoxserver.setting.EzyHomePathAware;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginsSetting;
import com.tvd12.ezyfoxserver.setting.EzySettingsDecorator;
import com.tvd12.ezyfoxserver.setting.EzySimpleAdminSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleAdminsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleAppSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleAppsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleEventControllerSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleEventControllersSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleHttpSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleLoggerSetting;
import com.tvd12.ezyfoxserver.setting.EzySimplePluginSetting;
import com.tvd12.ezyfoxserver.setting.EzySimplePluginsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSessionManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSettings;
import com.tvd12.ezyfoxserver.setting.EzySimpleSocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSslConfigSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleThreadPoolSizeSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleUdpSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleWebSocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleZoneSetting;
import com.tvd12.ezyfoxserver.setting.EzyUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.reader.FileReader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntConsumer;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.socket.controller.SocketGlobalServerReadyEventHandler;
import org.youngmonkeys.ezyplatform.socket.entry.DefaultPluginEntryLoader;
import org.youngmonkeys.ezyplatform.socket.settings.ModuleMetadata;
import org.youngmonkeys.ezyplatform.socket.settings.ModuleProperties;
import org.youngmonkeys.ezyplatform.socket.settings.SocketModuleMetadataReader;
import org.youngmonkeys.ezyplatform.socket.settings.SocketModulePropertiesReader;

public class SocketSettingsDecorator
extends EzyLoggable
implements EzySettingsDecorator {
    private final FileReader fileReader = new BaseFileReader();
    private final SocketModuleMetadataReader moduleMetadataReader = new SocketModuleMetadataReader();
    private final SocketModulePropertiesReader modulePropertiesReader = new SocketModulePropertiesReader();
    private static final String FILE_CONFIG_SOCKET = "socket/settings/config.properties";
    private static final String FILE_SETTINGS_SOCKET = "socket/settings/ezy-settings.json";
    private static final String PROPERTY_KEY_WS_SSL_ENABLE = "websocket.ssl.enable";

    public void decorate(String homePath, EzySimpleSettings settings) {
        String platformHomePath = Paths.get(homePath, new String[0]).toAbsolutePath().getParent().toString();
        this.setProperties(platformHomePath, settings);
        this.decorateSettingsProperties(platformHomePath, settings);
        this.addEventListeners(settings);
        this.registerPlugins(platformHomePath, homePath, settings);
        this.registerApps(platformHomePath, homePath, settings);
        this.addDefaultPluginToZonesIfAbsent(homePath, settings);
        this.decorateSettingsProperties(platformHomePath, settings);
    }

    private void setProperties(String platformHomePath, EzySimpleSettings settings) {
        Properties properties = this.fileReader.read(Paths.get(platformHomePath, FILE_CONFIG_SOCKET).toFile());
        EzySimpleWebSocketSetting webSocketSetting = settings.getWebsocket();
        webSocketSetting.setSslActive(Boolean.parseBoolean(properties.getOrDefault((Object)PROPERTY_KEY_WS_SSL_ENABLE, Boolean.FALSE).toString()));
    }

    private void addEventListeners(EzySimpleSettings settings) {
        EzySimpleEventControllersSetting controllers = settings.getEventControllers();
        controllers.setItem(new EzyEventControllerSettingBuilder().eventType(EzyEventType.SERVER_READY).controller(SocketGlobalServerReadyEventHandler.class).build());
    }

    private void registerPlugins(String platformHomePath, String homePath, EzySimpleSettings settings) {
        EzyXmlReader xmlReader = this.newXmlReader();
        Map<String, ModuleMetadata> pluginMetadataMap = this.moduleMetadataReader.readModuleMetadataMap(platformHomePath, ModuleType.SOCKET_PLUGIN);
        for (File pluginFolder : this.getPluginFolders(homePath)) {
            EzySimplePluginSetting plugin;
            ModuleMetadata moduleMetadata;
            String pluginName = pluginFolder.getName();
            if (!pluginName.equals("socket-monitor") && ((moduleMetadata = pluginMetadataMap.get(pluginName)) == null || !moduleMetadata.isActive())) continue;
            ModuleProperties moduleProperties = this.modulePropertiesReader.read(pluginFolder);
            String zoneName = moduleProperties.getZoneName();
            EzySimpleZoneSetting zoneSetting = this.getZoneSetting(settings, zoneName);
            if (zoneSetting == null) {
                zoneSetting = this.readZoneSetting(xmlReader, pluginFolder.toString(), moduleProperties.getZoneSettingFile());
                this.postReadZoneSetting(homePath, (EzyZoneSetting)zoneSetting);
                zoneSetting.setName(zoneName);
                zoneSetting.init();
                settings.addZone(zoneSetting);
            }
            if ((plugin = this.getPluginSetting(zoneSetting, pluginName)) != null) continue;
            plugin = new EzySimplePluginSetting();
            plugin.setName(pluginName);
            plugin.setFolder(pluginName);
            plugin.setEntryLoader(this.getEntryLoader(moduleProperties));
            plugin.setConfigFile(moduleProperties.getConfigFile());
            plugin.setPackageName(moduleProperties.getPackageName());
            plugin.setPriority(moduleProperties.getPriority());
            EzySimplePluginSetting.EzySimpleListenEvents listenEvents = plugin.getListenEvents();
            for (String listenEvent : moduleProperties.getListenEvents()) {
                listenEvents.setEvent(listenEvent);
            }
            plugin.setThreadPoolSize(moduleProperties.getThreadPoolSize());
            plugin.setHomePath(homePath);
            zoneSetting.getPlugins().setItem(plugin);
            this.logger.info("zone: {} added plugin: {}", (Object)zoneName, (Object)pluginName);
        }
    }

    private void registerApps(String platformHomePath, String homePath, EzySimpleSettings settings) {
        Map<String, ModuleMetadata> appMetadataMap = this.moduleMetadataReader.readModuleMetadataMap(platformHomePath, ModuleType.SOCKET_APP);
        for (File appFolder : this.getAppFolders(homePath)) {
            String appName = appFolder.getName();
            ModuleMetadata moduleMetadata = appMetadataMap.get(appName);
            if (moduleMetadata == null || !moduleMetadata.isActive()) continue;
            ModuleProperties moduleProperties = this.modulePropertiesReader.read(appFolder);
            String zoneName = moduleProperties.getZoneName();
            EzySimpleZoneSetting zoneSetting = this.getZoneSetting(settings, zoneName);
            if (zoneSetting == null) {
                this.logger.warn("can not start: {} app due to zone: {} not found", (Object)zoneName, (Object)appName);
                continue;
            }
            EzySimpleAppSetting app = this.getAppSetting(zoneSetting, appName);
            if (app != null) continue;
            app = new EzySimpleAppSetting();
            app.setName(appName);
            app.setFolder(appName);
            app.setEntryLoader(this.getEntryLoader(moduleProperties));
            app.setConfigFile(moduleProperties.getConfigFile());
            app.setPackageName(moduleProperties.getPackageName());
            app.setMaxUsers(moduleProperties.getMaxUsers());
            app.setThreadPoolSize(moduleProperties.getThreadPoolSize());
            app.setHomePath(homePath);
            zoneSetting.getApplications().setItem(app);
            this.logger.info("zone: {} added app: {}", (Object)zoneName, (Object)appName);
        }
    }

    private void addDefaultPluginToZonesIfAbsent(String homePath, EzySimpleSettings settings) {
        for (String zoneName : settings.getZoneNames()) {
            EzySimpleZoneSetting zone = settings.getZoneByName(zoneName);
            EzySimplePluginsSetting plugins = zone.getPlugins();
            if (plugins.getSize() > 0) continue;
            EzySimplePluginSetting plugin = this.createPlugin(homePath);
            plugins.setItem(plugin);
            this.logger.info("zone: {} added plugin: default", (Object)zoneName);
        }
    }

    private EzySimplePluginSetting createPlugin(String homePath) {
        EzySimplePluginSetting plugin = new EzySimplePluginSetting();
        plugin.setName("default");
        plugin.setFolder("default");
        plugin.setEntryLoader(DefaultPluginEntryLoader.class);
        plugin.setPackageName("org.youngmonkeys.ezyplatform.socket");
        plugin.setPriority(Integer.MAX_VALUE);
        EzySimplePluginSetting.EzySimpleListenEvents listenEvents = plugin.getListenEvents();
        listenEvents.setEvent("USER_LOGIN");
        plugin.setHomePath(homePath);
        return plugin;
    }

    private String getEntryLoader(ModuleProperties properties) {
        String packageName = properties.getPackageName();
        String entryLoader = properties.getEntryLoader();
        if (EzyStrings.isNotBlank((String)packageName) && entryLoader != null) {
            String entryLoaderFullName = entryLoader.contains(packageName) ? entryLoader : packageName + "." + entryLoader;
            try {
                Class.forName(entryLoaderFullName);
                entryLoader = entryLoaderFullName;
            }
            catch (Throwable e) {
                this.logger.info("can not get entry loader of packageName: {}, entryLoader: {} due to: {} ({})", new Object[]{packageName, entryLoader, e.getClass(), e.getMessage()});
            }
        }
        return entryLoader;
    }

    private EzySimpleZoneSetting getZoneSetting(EzySimpleSettings settings, String zoneName) {
        try {
            return settings.getZoneByName(zoneName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private EzySimplePluginSetting getPluginSetting(EzySimpleZoneSetting zoneSetting, String pluginName) {
        try {
            return zoneSetting.getPluginByName(pluginName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private EzySimpleAppSetting getAppSetting(EzySimpleZoneSetting zoneSetting, String appName) {
        try {
            return zoneSetting.getAppByName(appName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<File> getPluginFolders(String homePath) {
        return FileSystemManager.getModuleFolders((String)homePath, (String)"plugins");
    }

    private List<File> getAppFolders(String homePath) {
        return FileSystemManager.getModuleFolders((String)homePath, (String)"apps");
    }

    private EzyXmlReader newXmlReader() {
        return EzySimpleXmlMapper.builder().classLoader(this.getClassLoader()).contextPath("com.tvd12.ezyfoxserver").build();
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private EzySimpleZoneSetting readZoneSetting(EzyXmlReader xmlReader, String pluginFolder, String zoneSettingFile) {
        File file;
        String settingFile = null;
        if (EzyStrings.isNotBlank((String)zoneSettingFile) && !(file = new File(settingFile = Paths.get(pluginFolder, zoneSettingFile).toString())).exists()) {
            settingFile = null;
        }
        if (settingFile == null) {
            EzySimpleZoneSetting zoneSetting = new EzySimpleZoneSetting();
            zoneSetting.setMaxUsers(1000000);
            EzySimpleUserManagementSetting userManagementSetting = zoneSetting.getUserManagement();
            userManagementSetting.setAllowGuestLogin(false);
            userManagementSetting.setMaxSessionPerUser(30);
            userManagementSetting.setUserNamePattern(".*");
            userManagementSetting.setUserMaxIdleTimeInSecond(15L);
            return zoneSetting;
        }
        return (EzySimpleZoneSetting)xmlReader.read(settingFile, EzySimpleZoneSetting.class);
    }

    protected void postReadZoneSetting(String homePath, EzyZoneSetting zoneSetting) {
        this.updatePluginsSetting(homePath, zoneSetting.getPlugins());
        this.updateAppsSetting(homePath, zoneSetting.getApplications());
        this.updateUserManagementSetting(zoneSetting.getUserManagement());
    }

    private void updateAppsSetting(String homePath, EzyAppsSetting apps) {
        for (EzyAppSetting app : apps.getApps()) {
            ((EzyHomePathAware)app).setHomePath(homePath);
        }
    }

    private void updatePluginsSetting(String homePath, EzyPluginsSetting plugins) {
        for (EzyPluginSetting plugin : plugins.getPlugins()) {
            ((EzyHomePathAware)plugin).setHomePath(homePath);
        }
    }

    private void updateUserManagementSetting(EzyUserManagementSetting setting) {
        ((EzyInitable)setting).init();
    }

    private void decorateSettingsProperties(String platformHomePath, EzySimpleSettings settings) {
        Path file = Paths.get(platformHomePath, FILE_SETTINGS_SOCKET);
        this.logger.info("decorate settings with file: {}", (Object)file);
        if (!Files.exists(file, new LinkOption[0])) {
            this.logger.info("not found json file: {}", (Object)file);
            return;
        }
        try {
            String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            if (EzyStrings.isBlank((String)content)) {
                return;
            }
            Map customSettings = (Map)new ObjectMapper().readValue(content, Map.class);
            if (customSettings == null) {
                return;
            }
            this.logger.info("decorate settings with data: {}", (Object)customSettings);
            this.decorateServerSettingsProperties(settings, customSettings);
            this.decorateStreamingSettingsProperties(settings, customSettings);
            this.decorateHttpSettingsProperties(settings, customSettings);
            this.decorateSocketSettingsProperties(settings, customSettings);
            this.decorateUdpSettingsProperties(settings, customSettings);
            this.decorateAdministratorsSettingsProperties(settings, customSettings);
            this.decorateLoggerSettingsProperties(settings, customSettings);
            this.decorateWebSocketSettingsProperties(settings, customSettings);
            this.decorateThreadPoolSizeProperties(settings.getThreadPoolSize(), customSettings);
            this.decorateSessionManagementSettingsProperties(settings, customSettings);
            this.decorateEventControllersSettingsProperties(settings, customSettings);
            this.decorateZonesSettingsProperties(settings, customSettings);
        }
        catch (Exception e) {
            this.logger.warn("read custom socket settings failed: {}", (Object)file, (Object)e);
        }
    }

    private void decorateServerSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Integer maxSessions;
        String nodeName;
        Boolean debug = this.getBooleanValue(properties, "debug");
        if (debug != null) {
            settings.setDebug(debug.booleanValue());
        }
        if ((nodeName = this.getStringValue(properties, "nodeName", "node-name")) != null) {
            settings.setNodeName(nodeName);
        }
        if ((maxSessions = this.getIntegerValue(properties, "maxSessions", "max-sessions")) != null) {
            settings.setMaxSessions(maxSessions.intValue());
        }
    }

    private void decorateZonesSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Object zonesValue = this.getPropertyValue(properties, "zones");
        List<Map<String, Object>> zoneMaps = this.toMapList(zonesValue, "zone");
        this.logger.info("decorate zones settings with data: {}", zonesValue);
        if (zoneMaps.isEmpty()) {
            return;
        }
        for (Map<String, Object> zoneMap : zoneMaps) {
            Map<String, Object> applications;
            Map<String, Object> plugins;
            Map<String, Object> userManagement;
            Boolean streamingEnable;
            Map<String, Object> streaming;
            Integer maxUsers;
            EzySimpleZoneSetting zoneSetting;
            this.logger.info("decorate zone settings with data: {}", zoneMap);
            String zoneName = this.getStringValue(zoneMap, "name");
            if (zoneName == null || (zoneSetting = this.getZoneIfExists(settings, zoneName)) == null) continue;
            String configFile = this.getStringValue(zoneMap, "configFile", "config-file");
            if (configFile != null) {
                zoneSetting.setConfigFile(configFile);
            }
            if ((maxUsers = this.getIntegerValue(zoneMap, "maxUsers", "max-users")) != null) {
                zoneSetting.setMaxUsers(maxUsers.intValue());
            }
            if ((streaming = this.getMapValue(zoneMap, "streaming")) != null && (streamingEnable = this.getBooleanValue(streaming, "enable")) != null) {
                zoneSetting.getStreaming().setEnable(streamingEnable.booleanValue());
            }
            if ((userManagement = this.getMapValue(zoneMap, "userManagement", "user-management")) != null) {
                this.decorateUserManagementSetting(zoneSetting.getUserManagement(), userManagement);
            }
            if ((plugins = this.getMapValue(zoneMap, "plugins")) != null) {
                this.decorateZonePlugins(zoneSetting.getPlugins(), plugins);
            }
            if ((applications = this.getMapValue(zoneMap, "applications")) != null) {
                this.decorateZoneApplications(zoneSetting.getApplications(), applications);
            }
            this.decorateZoneEventControllers(zoneSetting, zoneMap);
        }
    }

    private void decorateStreamingSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Map<String, Object> streaming = this.getMapValue(properties, "streaming");
        this.logger.info("decorate streaming settings with data: {}", streaming);
        if (streaming == null) {
            return;
        }
        Boolean enable = this.getBooleanValue(streaming, "enable");
        if (enable != null) {
            settings.getStreaming().setEnable(enable.booleanValue());
        }
    }

    private void decorateHttpSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Integer maxThreads;
        Boolean active;
        Map<String, Object> http = this.getMapValue(properties, "http");
        this.logger.info("decorate http settings with data: {}", http);
        if (http == null) {
            return;
        }
        EzySimpleHttpSetting httpSetting = settings.getHttp();
        Integer port = this.getIntegerValue(http, "port");
        if (port != null) {
            httpSetting.setPort(port.intValue());
        }
        if ((active = this.getBooleanValue(http, "active")) != null) {
            httpSetting.setActive(active.booleanValue());
        }
        if ((maxThreads = this.getIntegerValue(http, "maxThreads", "max-threads")) != null) {
            httpSetting.setMaxThreads(maxThreads.intValue());
        }
    }

    private void decorateSocketSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Integer writerThreadPoolSize;
        Boolean tcpNoDelay;
        Integer maxRequestSize;
        Integer sslHandshakeTimeout;
        String sslType;
        String codecCreator;
        Boolean sslActive;
        Boolean active;
        String address;
        Map<String, Object> socket = this.getMapValue(properties, "socket");
        this.logger.info("decorate socket settings with data: {}", socket);
        if (socket == null) {
            return;
        }
        EzySimpleSocketSetting socketSetting = settings.getSocket();
        Integer port = this.getIntegerValue(socket, "port");
        if (port != null) {
            socketSetting.setPort(port.intValue());
        }
        if ((address = this.getStringValue(socket, "address")) != null) {
            socketSetting.setAddress(address);
        }
        if ((active = this.getBooleanValue(socket, "active")) != null) {
            socketSetting.setActive(active.booleanValue());
        }
        if ((sslActive = this.getBooleanValue(socket, "sslActive", "ssl-active")) != null) {
            socketSetting.setSslActive(sslActive.booleanValue());
        }
        if ((codecCreator = this.getStringValue(socket, "codecCreator", "codec-creator")) != null) {
            socketSetting.setCodecCreator(codecCreator);
        }
        if ((sslType = this.getStringValue(socket, "sslType", "ssl-type")) != null) {
            try {
                socketSetting.setSslType(SslType.valueOf((String)sslType));
            }
            catch (Exception e) {
                this.logger.warn("invalid sslType: {}", (Object)sslType);
            }
        }
        if ((sslHandshakeTimeout = this.getIntegerValue(socket, "sslHandshakeTimeout", "ssl-handshake-timeout")) != null) {
            socketSetting.setSslHandshakeTimeout(sslHandshakeTimeout.intValue());
        }
        if ((maxRequestSize = this.getIntegerValue(socket, "maxRequestSize", "max-request-size")) != null) {
            socketSetting.setMaxRequestSize(maxRequestSize.intValue());
        }
        if ((tcpNoDelay = this.getBooleanValue(socket, "tcpNoDelay", "tcp-no-delay")) != null) {
            socketSetting.setTcpNoDelay(tcpNoDelay.booleanValue());
        }
        if ((writerThreadPoolSize = this.getIntegerValue(socket, "writerThreadPoolSize", "writer-thread-pool-size")) != null) {
            socketSetting.setWriterThreadPoolSize(writerThreadPoolSize.intValue());
        }
    }

    private void decorateUdpSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Integer handlerThreadPoolSize;
        Integer channelPoolSize;
        Integer maxRequestSize;
        Boolean active;
        String address;
        Map<String, Object> udp = this.getMapValue(properties, "udp");
        this.logger.info("decorate udp settings with data: {}", udp);
        if (udp == null) {
            return;
        }
        EzySimpleUdpSetting udpSetting = settings.getUdp();
        Integer port = this.getIntegerValue(udp, "port");
        if (port != null) {
            udpSetting.setPort(port.intValue());
        }
        if ((address = this.getStringValue(udp, "address")) != null) {
            udpSetting.setAddress(address);
        }
        if ((active = this.getBooleanValue(udp, "active")) != null) {
            udpSetting.setActive(active.booleanValue());
        }
        if ((maxRequestSize = this.getIntegerValue(udp, "maxRequestSize", "max-request-size")) != null) {
            udpSetting.setMaxRequestSize(maxRequestSize.intValue());
        }
        if ((channelPoolSize = this.getIntegerValue(udp, "channelPoolSize", "channel-pool-size")) != null) {
            udpSetting.setChannelPoolSize(channelPoolSize.intValue());
        }
        if ((handlerThreadPoolSize = this.getIntegerValue(udp, "handlerThreadPoolSize", "handler-thread-pool-size")) != null) {
            udpSetting.setHandlerThreadPoolSize(handlerThreadPoolSize.intValue());
        }
    }

    private void decorateWebSocketSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Boolean managementEnable;
        String codecCreator;
        Integer maxHandlerThreadPoolSize;
        Integer minHandlerThreadPoolSize;
        Integer writerThreadPoolSize;
        Integer maxFrameSize;
        Boolean sslActive;
        Integer sslPort;
        Boolean active;
        String address;
        Map<String, Object> webSocket = this.getMapValue(properties, "websocket", "web-socket", "webSocket");
        this.logger.info("decorate websocket settings with data: {}", webSocket);
        if (webSocket == null) {
            return;
        }
        EzySimpleWebSocketSetting webSocketSetting = settings.getWebsocket();
        Integer port = this.getIntegerValue(webSocket, "port");
        if (port != null) {
            webSocketSetting.setPort(port.intValue());
        }
        if ((address = this.getStringValue(webSocket, "address")) != null) {
            webSocketSetting.setAddress(address);
        }
        if ((active = this.getBooleanValue(webSocket, "active")) != null) {
            webSocketSetting.setActive(active.booleanValue());
        }
        if ((sslPort = this.getIntegerValue(webSocket, "sslPort", "ssl-port")) != null) {
            webSocketSetting.setSslPort(sslPort.intValue());
        }
        if ((sslActive = this.getBooleanValue(webSocket, "sslActive", "ssl-active")) != null) {
            webSocketSetting.setSslActive(sslActive.booleanValue());
        }
        if ((maxFrameSize = this.getIntegerValue(webSocket, "maxFrameSize", "max-frame-size")) != null) {
            webSocketSetting.setMaxFrameSize(maxFrameSize.intValue());
        }
        if ((writerThreadPoolSize = this.getIntegerValue(webSocket, "writerThreadPoolSize", "writer-thread-pool-size")) != null) {
            webSocketSetting.setWriterThreadPoolSize(writerThreadPoolSize.intValue());
        }
        if ((minHandlerThreadPoolSize = this.getIntegerValue(webSocket, "minHandlerThreadPoolSize", "min-handler-thread-pool-size")) != null) {
            webSocketSetting.setMinHandlerThreadPoolSize(minHandlerThreadPoolSize.intValue());
        }
        if ((maxHandlerThreadPoolSize = this.getIntegerValue(webSocket, "maxHandlerThreadPoolSize", "max-handler-thread-pool-size")) != null) {
            webSocketSetting.setMaxHandlerThreadPoolSize(maxHandlerThreadPoolSize.intValue());
        }
        if ((codecCreator = this.getStringValue(webSocket, "codecCreator", "codec-creator")) != null) {
            webSocketSetting.setCodecCreator(codecCreator);
        }
        if ((managementEnable = this.getBooleanValue(webSocket, "managementEnable", "management-enable")) != null) {
            webSocketSetting.setManagementEnable(managementEnable.booleanValue());
        }
        Map<String, Object> sslConfig = this.getMapValue(webSocket, "sslConfig", "ssl-config");
        this.logger.info("decorate ssl settings with data: {}", sslConfig);
        if (sslConfig != null) {
            this.decorateSslConfigProperties(webSocketSetting.getSslConfig(), sslConfig);
        }
    }

    private void decorateSslConfigProperties(EzySimpleSslConfigSetting sslConfigSetting, Map<String, Object> properties) {
        String contextFactoryBuilder;
        String loader;
        String file = this.getStringValue(properties, "file");
        if (file != null) {
            sslConfigSetting.setFile(file);
        }
        if ((loader = this.getStringValue(properties, "loader")) != null) {
            sslConfigSetting.setLoader(loader);
        }
        if ((contextFactoryBuilder = this.getStringValue(properties, "contextFactoryBuilder", "context-factory-builder")) != null) {
            sslConfigSetting.setContextFactoryBuilder(contextFactoryBuilder);
        }
    }

    private void decorateAdministratorsSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Object administrators = this.getPropertyValue(properties, "administrators");
        this.logger.info("decorate administrators settings with data: {}", administrators);
        List<Map<String, Object>> adminMaps = this.toMapList(administrators, "administrator");
        if (adminMaps.isEmpty()) {
            return;
        }
        EzySimpleAdminsSetting adminsSetting = new EzySimpleAdminsSetting();
        for (Map<String, Object> admin : adminMaps) {
            String username = this.getStringValue(admin, "username");
            if (username == null) continue;
            String password = this.getStringValue(admin, "password");
            if (password == null) continue;
            EzySimpleAdminSetting simpleAdmin = new EzySimpleAdminSetting();
            simpleAdmin.setUsername(username);
            simpleAdmin.setPassword(password);
            String accessToken = this.getStringValue(admin, "accessToken", "access-token");
            if (accessToken != null) {
                simpleAdmin.setAccessToken(accessToken);
            }
            adminsSetting.setItem(simpleAdmin);
        }
        if (!adminsSetting.getAdmins().isEmpty()) {
            settings.setAdmins(adminsSetting);
        }
    }

    private void decorateSessionManagementSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Map<String, Object> maxRequests;
        Integer maxWaiting;
        Map<String, Object> sessionManagement = this.getMapValue(properties, "sessionManagement", "session-management");
        this.logger.info("decorate session management settings with data: {}", sessionManagement);
        if (sessionManagement == null) {
            return;
        }
        EzySimpleSessionManagementSetting sessionSetting = settings.getSessionManagement();
        Integer maxIdle = this.getIntegerValue(sessionManagement, "sessionMaxIdleTimeInSecond", "session-max-idle-time-in-second");
        if (maxIdle != null) {
            sessionSetting.setSessionMaxIdleTimeInSecond((long)maxIdle.intValue());
            sessionSetting.setSessionMaxIdleTime((long)(maxIdle * 1000));
        }
        if ((maxWaiting = this.getIntegerValue(sessionManagement, "sessionMaxWaitingTimeInSecond", "session-max-waiting-time-in-second")) != null) {
            sessionSetting.setSessionMaxWaitingTimeInSecond((long)maxWaiting.intValue());
            sessionSetting.setSessionMaxWaitingTime((long)(maxWaiting * 1000));
        }
        if ((maxRequests = this.getMapValue(sessionManagement, "sessionMaxRequestPerSecond", "session-max-request-per-second")) != null) {
            String action;
            Integer value = this.getIntegerValue(maxRequests, "value");
            if (value != null) {
                sessionSetting.getSessionMaxRequestPerSecond().setValue(value.intValue());
            }
            if ((action = this.getStringValue(maxRequests, "action")) != null) {
                try {
                    sessionSetting.getSessionMaxRequestPerSecond().setAction(EzyMaxRequestPerSecondAction.valueOf((String)action));
                }
                catch (Exception e) {
                    this.logger.warn("invalid session max request action: {}", (Object)action);
                }
            }
        }
    }

    private void decorateThreadPoolSizeProperties(EzySimpleThreadPoolSizeSetting threadPoolSizeSetting, Map<String, Object> properties) {
        Map<String, Object> threadPoolSize = this.getMapValue(properties, "threadPoolSize", "thread-pool-size");
        this.logger.info("decorate thread pool size settings with data: {}", threadPoolSize);
        if (threadPoolSize == null) {
            return;
        }
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setStatistics(arg_0), threadPoolSize, "statistics");
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setStreamHandler(arg_0), threadPoolSize, "streamHandler", "stream-handler");
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setSocketDataReceiver(arg_0), threadPoolSize, "socketDataReceiver", "socket-data-receiver");
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setSystemRequestHandler(arg_0), threadPoolSize, "systemRequestHandler", "system-request-handler");
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setExtensionRequestHandler(arg_0), threadPoolSize, "extensionRequestHandler", "extension-request-handler");
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setSocketDisconnectionHandler(arg_0), threadPoolSize, "socketDisconnectionHandler", "socket-disconnection-handler");
        this.setIntValue(arg_0 -> ((EzySimpleThreadPoolSizeSetting)threadPoolSizeSetting).setSocketUserRemovalHandler(arg_0), threadPoolSize, "socketUserRemovalHandler", "socket-user-removal-handler");
    }

    private void decorateUserManagementSetting(EzySimpleUserManagementSetting setting, Map<String, Object> properties) {
        String userNamePattern;
        String guestNamePrefix;
        Boolean allowChangeSession;
        Boolean allowGuestLogin;
        Integer maxSessionPerUser;
        Integer idleTime = this.getIntegerValue(properties, "userMaxIdleTimeInSecond", "user-max-idle-time-in-second");
        if (idleTime != null) {
            setting.setUserMaxIdleTimeInSecond((long)idleTime.intValue());
            setting.setUserMaxIdleTime((long)(idleTime * 1000));
        }
        if ((maxSessionPerUser = this.getIntegerValue(properties, "maxSessionPerUser", "max-session-per-user")) != null) {
            setting.setMaxSessionPerUser(maxSessionPerUser.intValue());
        }
        if ((allowGuestLogin = this.getBooleanValue(properties, "allowGuestLogin", "allow-guest-login")) != null) {
            setting.setAllowGuestLogin(allowGuestLogin.booleanValue());
        }
        if ((allowChangeSession = this.getBooleanValue(properties, "allowChangeSession", "allow-change-session")) != null) {
            setting.setAllowChangeSession(allowChangeSession.booleanValue());
        }
        if ((guestNamePrefix = this.getStringValue(properties, "guestNamePrefix", "guest-name-prefix")) != null) {
            setting.setGuestNamePrefix(guestNamePrefix);
        }
        if ((userNamePattern = this.getStringValue(properties, "userNamePattern", "user-name-pattern")) != null) {
            setting.setUserNamePattern(userNamePattern);
        }
    }

    private EzySimpleZoneSetting getZoneIfExists(EzySimpleSettings settings, String zoneName) {
        try {
            return settings.getZoneNames().contains(zoneName) ? settings.getZoneByName(zoneName) : null;
        }
        catch (Exception e) {
            this.logger.info("zone: {} not found to decorate", (Object)zoneName);
            return null;
        }
    }

    private void decorateEventControllersSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Object controllersObj = this.getPropertyValue(properties, "eventControllers", "event-controllers");
        this.logger.info("decorate event controllers settings with data: {}", controllersObj);
        if (controllersObj == null) {
            return;
        }
        List<Map<String, Object>> controllers = this.toMapList(controllersObj, "event-controller");
        if (controllers.isEmpty()) {
            return;
        }
        EzySimpleEventControllersSetting controllersSetting = new EzySimpleEventControllersSetting();
        for (Map<String, Object> controller : controllers) {
            String eventType = this.getStringValue(controller, "eventType", "event-type");
            String controllerClass = this.getStringValue(controller, "controller");
            if (eventType == null || controllerClass == null) continue;
            EzySimpleEventControllerSetting controllerSetting = new EzySimpleEventControllerSetting();
            controllerSetting.setEventType(eventType);
            controllerSetting.setController(controllerClass);
            controllersSetting.setItem(controllerSetting);
        }
        if (!controllersSetting.getEventControllers().isEmpty()) {
            settings.setEventControllers(controllersSetting);
        }
    }

    private void decorateZoneEventControllers(EzySimpleZoneSetting zoneSetting, Map<String, Object> properties) {
        Object controllersObj = this.getPropertyValue(properties, "eventControllers", "event-controllers");
        this.logger.info("decorate zone event controllers settings with data: {}", controllersObj);
        if (controllersObj == null) {
            return;
        }
        List<Map<String, Object>> controllers = this.toMapList(controllersObj, "event-controller");
        if (controllers.isEmpty()) {
            return;
        }
        EzySimpleEventControllersSetting controllersSetting = new EzySimpleEventControllersSetting();
        for (Map<String, Object> controller : controllers) {
            String eventType = this.getStringValue(controller, "eventType", "event-type");
            String controllerClass = this.getStringValue(controller, "controller");
            if (eventType == null || controllerClass == null) continue;
            EzySimpleEventControllerSetting controllerSetting = new EzySimpleEventControllerSetting();
            controllerSetting.setEventType(eventType);
            controllerSetting.setController(controllerClass);
            controllersSetting.setItem(controllerSetting);
        }
        if (!controllersSetting.getEventControllers().isEmpty()) {
            zoneSetting.setEventControllers(controllersSetting);
        }
    }

    private void decorateZonePlugins(EzySimplePluginsSetting pluginsSetting, Map<String, Object> properties) {
        Object plugins = this.getPropertyValue(properties, "plugins");
        List<Map<String, Object>> pluginMaps = this.toMapList(plugins, "plugin");
        if (pluginMaps.isEmpty()) {
            return;
        }
        for (Map<String, Object> plugin : pluginMaps) {
            EzySimplePluginSetting pluginSetting;
            this.logger.info("decorate plugin settings with data: {}", plugin);
            String pluginName = this.getStringValue(plugin, "name");
            if (pluginName == null || (pluginSetting = this.getPluginIfExists(pluginsSetting, pluginName)) == null) continue;
            this.applyPluginFields(pluginSetting, plugin);
        }
    }

    private void decorateZoneApplications(EzySimpleAppsSetting appsSetting, Map<String, Object> properties) {
        Object applications = this.getPropertyValue(properties, "applications");
        List<Map<String, Object>> appMaps = this.toMapList(applications, "application");
        if (appMaps.isEmpty()) {
            return;
        }
        for (Map<String, Object> app : appMaps) {
            EzySimpleAppSetting appSetting;
            this.logger.info("decorate app settings with data: {}", app);
            String appName = this.getStringValue(app, "name");
            if (appName == null || (appSetting = this.getAppIfExists(appsSetting, appName)) == null) continue;
            this.applyAppFields(appSetting, app);
        }
    }

    private void applyPluginFields(EzySimplePluginSetting pluginSetting, Map<String, Object> properties) {
        List<String> listenEvents;
        String configFile;
        String packageName;
        String folder;
        this.setIntValue(arg_0 -> ((EzySimplePluginSetting)pluginSetting).setPriority(arg_0), properties, "priority");
        this.setIntValue(arg_0 -> ((EzySimplePluginSetting)pluginSetting).setThreadPoolSize(arg_0), properties, "threadPoolSize", "thread-pool-size");
        String entryLoader = this.getStringValue(properties, "entryLoader", "entry-loader");
        if (entryLoader != null) {
            pluginSetting.setEntryLoader(entryLoader);
        }
        if ((folder = this.getStringValue(properties, "folder")) != null) {
            pluginSetting.setFolder(folder);
        }
        if ((packageName = this.getStringValue(properties, "packageName", "package-name")) != null) {
            pluginSetting.setPackageName(packageName);
        }
        if ((configFile = this.getStringValue(properties, "configFile", "config-file")) != null) {
            pluginSetting.setConfigFile(configFile);
        }
        if (!(listenEvents = this.toStringList(this.getPropertyValue(properties, "listenEvents", "listen-events"), "event")).isEmpty()) {
            pluginSetting.getListenEvents().getEvents().clear();
            for (String listenEvent : listenEvents) {
                try {
                    pluginSetting.getListenEvents().setEvent(listenEvent);
                }
                catch (Exception e) {
                    this.logger.warn("invalid listen event: {}", (Object)listenEvent);
                }
            }
        }
    }

    private void applyAppFields(EzySimpleAppSetting appSetting, Map<String, Object> properties) {
        String configFile;
        String packageName;
        String folder;
        this.setIntValue(arg_0 -> ((EzySimpleAppSetting)appSetting).setMaxUsers(arg_0), properties, "maxUsers", "max-users");
        this.setIntValue(arg_0 -> ((EzySimpleAppSetting)appSetting).setThreadPoolSize(arg_0), properties, "threadPoolSize", "thread-pool-size");
        String entryLoader = this.getStringValue(properties, "entryLoader", "entry-loader");
        if (entryLoader != null) {
            appSetting.setEntryLoader(entryLoader);
        }
        if ((folder = this.getStringValue(properties, "folder")) != null) {
            appSetting.setFolder(folder);
        }
        if ((packageName = this.getStringValue(properties, "packageName", "package-name")) != null) {
            appSetting.setPackageName(packageName);
        }
        if ((configFile = this.getStringValue(properties, "configFile", "config-file")) != null) {
            appSetting.setConfigFile(configFile);
        }
    }

    private EzySimplePluginSetting getPluginIfExists(EzySimplePluginsSetting pluginsSetting, String pluginName) {
        try {
            return pluginsSetting.getPluginByName(pluginName);
        }
        catch (Exception e) {
            this.logger.info("plugin: {} not found to decorate", (Object)pluginName);
            return null;
        }
    }

    private EzySimpleAppSetting getAppIfExists(EzySimpleAppsSetting appsSetting, String appName) {
        try {
            return appsSetting.getAppByName(appName);
        }
        catch (Exception e) {
            this.logger.info("app: {} not found to decorate", (Object)appName);
            return null;
        }
    }

    private void decorateLoggerSettingsProperties(EzySimpleSettings settings, Map<String, Object> properties) {
        Map<String, Object> valueMap = this.getMapValue(properties, "logger");
        this.logger.info("decorate logger settings with data: {}", valueMap);
        if (valueMap == null) {
            return;
        }
        Object ignoredCommands = this.getPropertyValue(valueMap, "ignoredCommands", "ignored-commands");
        List<String> commands = this.toStringList(ignoredCommands, "command");
        if (commands.isEmpty()) {
            return;
        }
        EzySimpleLoggerSetting loggerSetting = settings.getLogger();
        EzySimpleLoggerSetting.EzySimpleIgnoredCommandsSetting ignored = loggerSetting.getIgnoredCommands();
        Set commandSet = ignored.getCommands();
        commandSet.clear();
        for (String command : commands) {
            try {
                commandSet.add(EzyCommand.valueOf((String)command));
            }
            catch (Exception exception) {}
        }
    }

    private Object getPropertyValue(Map<String, Object> properties, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Map<String, Object> getMapValue(Map<String, Object> properties, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (!(value instanceof Map)) continue;
            return (Map)value;
        }
        return null;
    }

    private List<Map<String, Object>> toMapList(Object value, String ... childKeys) {
        Object target = value;
        if (target instanceof Map) {
            Map map = (Map)target;
            for (String childKey : childKeys) {
                Object nested = map.get(childKey);
                if (nested == null) continue;
                target = nested;
                break;
            }
        }
        if (target instanceof List) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Object item : (List)target) {
                if (!(item instanceof Map)) continue;
                result.add((Map)item);
            }
            return result;
        }
        if (target instanceof Map) {
            return Collections.singletonList((Map)target);
        }
        return Collections.emptyList();
    }

    private List<String> toStringList(Object value, String ... childKeys) {
        Object target = value;
        if (target instanceof Map) {
            Map map = (Map)target;
            for (String childKey : childKeys) {
                Object nested = map.get(childKey);
                if (nested == null) continue;
                target = nested;
                break;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (target instanceof List) {
            for (Object item : (List)target) {
                if (item == null) continue;
                result.add(item.toString());
            }
        } else if (target != null) {
            result.add(target.toString());
        }
        return result;
    }

    private String getStringValue(Map<String, Object> properties, String ... keys) {
        Object value = this.getPropertyValue(properties, keys);
        return value == null ? null : value.toString();
    }

    private Integer getIntegerValue(Map<String, Object> properties, String ... keys) {
        Object value = this.getPropertyValue(properties, keys);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt(((String)value).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private Boolean getBooleanValue(Map<String, Object> properties, String ... keys) {
        Object value = this.getPropertyValue(properties, keys);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean(((String)value).trim());
        }
        return null;
    }

    private void setIntValue(IntConsumer setter, Map<String, Object> properties, String ... keys) {
        Integer value = this.getIntegerValue(properties, keys);
        if (value != null) {
            setter.accept(value);
        }
    }
}

