/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.cli.data.Target;
import org.youngmonkeys.ezyplatform.cli.io.CliFolderProxy;
import org.youngmonkeys.ezyplatform.cli.io.CliObjectMapper;
import org.youngmonkeys.ezyplatform.entity.TargetType;

public final class CliTargetInformationInteractor {
    public static final CliTargetInformationInteractor INSTANCE = new CliTargetInformationInteractor();

    private CliTargetInformationInteractor() {
    }

    public static CliTargetInformationInteractor getInstance() {
        return INSTANCE;
    }

    public Map<TargetType, Target> readTargetMap() {
        return Arrays.stream(TargetType.values()).collect(Collectors.toMap(it -> it, this::readTarget));
    }

    public void saveTarget(Target target) throws IOException {
        File infoFile = CliFolderProxy.getTargetInfoFile(target.getType());
        CliFolderProxy.createFileIfNotExists(infoFile);
        CliObjectMapper.getInstance().writeValue(infoFile, target);
    }

    private Target readTarget(TargetType targetType) {
        File infoFile = CliFolderProxy.getTargetInfoFile(targetType);
        if (!infoFile.exists()) {
            return this.defaultTarget(targetType);
        }
        try {
            return CliObjectMapper.getInstance().readValue(infoFile, Target.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not read file: " + infoFile, e);
        }
    }

    private Target defaultTarget(TargetType targetType) {
        Target target = new Target();
        target.setType(targetType);
        target.setActive(true);
        return target;
    }
}

