/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.EzySimpleServer;
import com.tvd12.ezyfoxserver.ccl.EzyAppClassLoader;
import com.tvd12.ezyfoxserver.config.EzyConfig;
import com.tvd12.ezyfoxserver.service.impl.EzySimpleSessionTokenGenerator;
import com.tvd12.ezyfoxserver.setting.EzyEventControllersSetting;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySettingsDecorator;
import com.tvd12.ezyfoxserver.setting.EzySettingsReader;
import com.tvd12.ezyfoxserver.setting.EzySimpleSettingsReader;
import com.tvd12.ezyfoxserver.statistics.EzySimpleStatistics;
import com.tvd12.ezyfoxserver.statistics.EzyStatistics;
import com.tvd12.ezyfoxserver.wrapper.EzyEventControllers;
import com.tvd12.ezyfoxserver.wrapper.EzyServerControllers;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;
import com.tvd12.ezyfoxserver.wrapper.EzySimpleSessionManager;
import com.tvd12.ezyfoxserver.wrapper.impl.EzyEventControllersImpl;
import com.tvd12.ezyfoxserver.wrapper.impl.EzyServerControllersImpl;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EzyLoader
extends EzyLoggable {
    protected EzyConfig config;
    protected ClassLoader classLoader;
    protected EzySettingsDecorator settingsDecorator;

    public EzyServer load() {
        EzySettings settings = this.readSettings();
        EzySimpleServer answer = new EzySimpleServer();
        answer.setConfig(this.config);
        answer.setSettings(settings);
        answer.setClassLoader(this.classLoader);
        answer.setAppClassLoaders(this.newAppClassLoaders());
        answer.setStatistics(this.newStatistics());
        answer.setControllers(this.newControllers());
        answer.setSessionManager(this.newSessionManagers(settings));
        answer.setEventControllers(this.newEventControllers(settings.getEventControllers()));
        return answer;
    }

    protected EzySettings readSettings() {
        return this.newSettingsReader().read();
    }

    protected EzySettingsReader newSettingsReader() {
        return EzySimpleSettingsReader.builder().homePath(this.getHomePath()).classLoader(this.classLoader).settingsDecorator(this.settingsDecorator).build();
    }

    protected EzyStatistics newStatistics() {
        return new EzySimpleStatistics();
    }

    protected abstract EzySimpleSessionManager.Builder createSessionManagerBuilder(EzySettings var1);

    protected EzySessionManager newSessionManagers(EzySettings settings) {
        EzySimpleSessionManager.Builder builder = this.createSessionManagerBuilder(settings);
        EzySimpleSessionTokenGenerator tokenGenerator = new EzySimpleSessionTokenGenerator(settings.getNodeName());
        builder.tokenGenerator(tokenGenerator).maxSessions(settings.getMaxSessions());
        return builder.build();
    }

    protected EzyServerControllers newControllers() {
        return EzyServerControllersImpl.builder().build();
    }

    protected Map<String, ClassLoader> newAppClassLoaders() {
        File[] entryFolders;
        ConcurrentHashMap<String, ClassLoader> answer = new ConcurrentHashMap<String, ClassLoader>();
        for (File dir : entryFolders = this.getEntryFolders()) {
            answer.put(dir.getName(), this.newAppClassLoader(dir));
        }
        return answer;
    }

    protected ClassLoader newAppClassLoader(File dir) {
        this.logger.info("load: {}", (Object)dir);
        if (this.config.isEnableAppClassLoader()) {
            return new EzyAppClassLoader(dir, this.classLoader);
        }
        return this.classLoader;
    }

    protected EzyEventControllers newEventControllers(EzyEventControllersSetting setting) {
        return EzyEventControllersImpl.create(setting);
    }

    protected File[] getEntryFolders() {
        File entries = this.getEntriesFolder();
        File[] answer = entries.listFiles(File::isDirectory);
        return answer != null ? answer : new File[]{};
    }

    protected File getEntriesFolder() {
        String entriesPath = this.getEntriesPath();
        return new File(entriesPath);
    }

    protected String getEntriesPath() {
        return this.getPath(this.getAppsPath(), "entries");
    }

    protected String getAppsPath() {
        return this.getPath(this.getHomePath(), "apps");
    }

    protected String getPath(String first, String ... more) {
        return Paths.get(first, more).toString();
    }

    protected String getHomePath() {
        return this.config.getEzyfoxHome();
    }

    public EzyLoader classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public EzyLoader config(EzyConfig config) {
        this.config = config;
        return this;
    }

    public EzyLoader settingsDecorator(EzySettingsDecorator settingsDecorator) {
        this.settingsDecorator = settingsDecorator;
        return this;
    }
}

